/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.oss.internal;

import com.aliyun.common.comm.ResponseHandler;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.parser.JAXBResultParser;
import com.aliyun.common.parser.ResultParseException;
import com.aliyun.common.utils.ResourceManager;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.oss.OSSException;
import com.aliyun.openservices.oss.internal.OSSExceptionFactory;
import com.aliyun.openservices.oss.internal.OSSUtils;
import com.aliyun.openservices.oss.internal.model.OSSErrorResult;

public class OSSErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage responseData) throws OSSException, ClientException {
        assert (responseData != null);
        if (responseData.isSuccessful()) {
            return;
        }
        if (responseData.getContent() == null) {
            throw OSSExceptionFactory.createInvalidResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), null);
        }
        JAXBResultParser d = new JAXBResultParser(OSSErrorResult.class);
        try {
            try {
                OSSErrorResult err = (OSSErrorResult)d.getObject(responseData);
                throw OSSExceptionFactory.create(err);
            }
            catch (ResultParseException e) {
                throw OSSExceptionFactory.createInvalidResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), e);
            }
        }
        catch (Throwable throwable) {
            OSSUtils.safeCloseResponse(responseData);
            throw throwable;
        }
    }
}

