/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.internal.OTSOperation;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.model.GetRowResult;
import com.aliyun.openservices.ots.internal.model.GetRowsByOffsetResult;
import com.aliyun.openservices.ots.internal.model.GetRowsByRangeResult;
import com.aliyun.openservices.ots.model.ColumnValue;
import com.aliyun.openservices.ots.model.OffsetRowQueryCriteria;
import com.aliyun.openservices.ots.model.PrimaryKeyRange;
import com.aliyun.openservices.ots.model.PrimaryKeyValue;
import com.aliyun.openservices.ots.model.RangeRowQueryCriteria;
import com.aliyun.openservices.ots.model.Row;
import com.aliyun.openservices.ots.model.RowChange;
import com.aliyun.openservices.ots.model.RowDeleteChange;
import com.aliyun.openservices.ots.model.RowListing;
import com.aliyun.openservices.ots.model.RowPutChange;
import com.aliyun.openservices.ots.model.SingleRowQueryCriteria;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OTSDataOperation
extends OTSOperation {
    private static final String ACTION_GETROW = "GetRow";
    private static final String ACTION_GETROWSBYRANGE = "GetRowsByRange";
    private static final String ACTION_GETROWSBYOFFSET = "GetRowsByOffset";
    private static final String ACTION_PUTDATA = "PutData";
    private static final String ACTION_DELETEDATA = "DeleteData";
    private static final String ACTION_BATCHMODIFYDATA = "BatchModifyData";

    public OTSDataOperation(URI endpoint, ServiceClient client, ServiceCredentials credentials) {
        super(endpoint, client, credentials);
    }

    public Row getRow(SingleRowQueryCriteria criteria, String transactionId) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(criteria, "criteria");
        GetRowResult result = (GetRowResult)this.invoke(ACTION_GETROW, HttpMethod.POST, this.getGetRowParameters(criteria, transactionId), GetRowResult.class);
        if (result.Table != null && result.Table.Rows != null && result.Table.Rows.size() > 0) {
            return result.Table.Rows.get(0);
        }
        return null;
    }

    private Map<String, String> getGetRowParameters(SingleRowQueryCriteria criteria, String transactionId) {
        if (criteria.getPrimaryKeys().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("TableName", OTSUtil.getQueryEntityName(criteria));
        int pkIdx = 1;
        for (Map.Entry<String, PrimaryKeyValue> pk : criteria.getPrimaryKeys().entrySet()) {
            String pre = String.format("PK.%d.", pkIdx++);
            params.put(pre + "Name", pk.getKey());
            params.put(pre + "Value", OTSUtil.getParameterString(pk.getValue()));
            params.put(pre + "Type", pk.getValue().getType().toString());
        }
        int colIdx = 1;
        for (String col : criteria.getColumnNames()) {
            params.put(String.format("Column.%d.Name", colIdx++), col);
        }
        if (transactionId != null && transactionId.length() > 0) {
            params.put("TransactionID", transactionId);
        }
        return params;
    }

    public List<Row> getRowsByOffset(OffsetRowQueryCriteria criteria, String transactionId) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(criteria, "criteria");
        if (criteria.getPagingKeys().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        if (criteria.getTop() < 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetCriteriaTop"));
        }
        GetRowsByOffsetResult result = (GetRowsByOffsetResult)this.invoke(ACTION_GETROWSBYOFFSET, HttpMethod.POST, this.getGetRowsByOffsetParamters(criteria, transactionId), GetRowsByOffsetResult.class);
        if (result.Table.Rows != null) {
            return result.Table.Rows;
        }
        return new ArrayList<Row>();
    }

    private Map<String, String> getGetRowsByOffsetParamters(OffsetRowQueryCriteria criteria, String transactionId) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("TableName", OTSUtil.getQueryEntityName(criteria));
        int pkIdx = 1;
        for (Map.Entry<String, PrimaryKeyValue> pk : criteria.getPagingKeys().entrySet()) {
            String pre = String.format("Paging.%d.", pkIdx++);
            params.put(pre + "Name", pk.getKey());
            params.put(pre + "Value", OTSUtil.getParameterString(pk.getValue()));
            params.put(pre + "Type", pk.getValue().getType().toString());
        }
        int colIdx = 1;
        for (String col : criteria.getColumnNames()) {
            params.put(String.format("Column.%d.Name", colIdx++), col);
        }
        params.put("Offset", Integer.toString(criteria.getOffset()));
        params.put("Top", Integer.toString(criteria.getTop()));
        if (criteria.getIsReverse()) {
            params.put("IsReverse", Boolean.toString(criteria.getIsReverse()).toUpperCase());
        }
        if (transactionId != null && transactionId.length() > 0) {
            params.put("TransactionID", transactionId);
        }
        return params;
    }

    public List<Row> getRowsByRange(RangeRowQueryCriteria criteria, String transactionId) throws OTSException, ClientException {
        ArrayList<Row> rowList = new ArrayList<Row>();
        String nextToken = null;
        do {
            RowListing rowListing = this.getRowsByRange(criteria, transactionId, nextToken);
            nextToken = rowListing.getNextToken();
            rowList.addAll(rowListing.getRows());
        } while (nextToken != null);
        return rowList;
    }

    public RowListing getRowsByRange(RangeRowQueryCriteria criteria, String transactionId, String nextToken) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(criteria, "criteria");
        if (criteria.getRange() == null) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetCriteriaRange"));
        }
        boolean isReverse = criteria.getIsReverse();
        if (!isReverse && PrimaryKeyRange.INF_MAX.equals(criteria.getRange().getBegin())) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("BeginIsInfMax"));
        }
        if (isReverse && PrimaryKeyRange.INF_MIN.equals(criteria.getRange().getBegin())) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("BeginIsInfMin"));
        }
        int comp = OTSUtil.compare(criteria.getRange().getBegin(), criteria.getRange().getEnd());
        if (!isReverse && comp > 0 || isReverse && comp < 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("BeginEndIncorrect"));
        }
        GetRowsByRangeResult result = (GetRowsByRangeResult)this.invoke(ACTION_GETROWSBYRANGE, HttpMethod.POST, this.getGetRowsByRangeParamters(criteria, transactionId, nextToken), GetRowsByRangeResult.class);
        RowListing rowListing = new RowListing();
        rowListing.setNextToken(result.Table.NextToken);
        if (result.Table.Rows != null) {
            rowListing.setRows(result.Table.Rows);
        } else {
            rowListing.setRows(new ArrayList<Row>());
        }
        return rowListing;
    }

    private Map<String, String> getGetRowsByRangeParamters(RangeRowQueryCriteria criteria, String transactionId, String nextToken) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("TableName", OTSUtil.getQueryEntityName(criteria));
        int pkIdx = 1;
        for (Map.Entry<String, PrimaryKeyValue> pk : criteria.getPrimaryKeys().entrySet()) {
            String pre = String.format("PK.%d.", pkIdx++);
            params.put(pre + "Name", pk.getKey());
            params.put(pre + "Value", OTSUtil.getParameterString(pk.getValue()));
            params.put(pre + "Type", pk.getValue().getType().toString());
        }
        PrimaryKeyRange range = criteria.getRange();
        String rangePre = String.format("PK.%d.", pkIdx);
        params.put(rangePre + "Name", range.getPrimaryKeyName());
        params.put(rangePre + "RangeBegin", OTSUtil.getParameterString(range.getBegin()));
        params.put(rangePre + "RangeEnd", OTSUtil.getParameterString(range.getEnd()));
        params.put(rangePre + "RangeType", range.getType().toString());
        int colIdx = 1;
        for (String col : criteria.getColumnNames()) {
            params.put(String.format("Column.%d.Name", colIdx++), col);
        }
        if (criteria.getTop() >= 0) {
            params.put("Top", Integer.toString(criteria.getTop()));
        }
        if (transactionId != null && transactionId.length() > 0) {
            params.put("TransactionID", transactionId);
        }
        if (criteria.getIsReverse()) {
            params.put("IsReverse", Boolean.toString(criteria.getIsReverse()).toUpperCase());
        }
        if (nextToken != null && nextToken.length() > 0) {
            params.put("NextToken", nextToken);
        } else {
            params.put("NextToken", "");
        }
        return params;
    }

    public void putData(String tableName, RowPutChange rowChange, String transactionId) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableName, "tableName");
        OTSUtil.ensureNameValid(tableName);
        CodingUtils.assertParameterNotNull(rowChange, "rowChange");
        if (rowChange.getPrimaryKeys().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        this.invokeNoResult(ACTION_PUTDATA, HttpMethod.POST, this.getPutDataParameters(tableName, rowChange, transactionId));
    }

    private Map<String, String> getPutDataParameters(String tableName, RowPutChange rowChange, String transactionId) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("TableName", tableName);
        int pkIdx = 1;
        for (Map.Entry<String, PrimaryKeyValue> pk : rowChange.getPrimaryKeys().entrySet()) {
            String pre = String.format("PK.%d.", pkIdx++);
            params.put(pre + "Name", pk.getKey());
            params.put(pre + "Value", OTSUtil.getParameterString(pk.getValue()));
            params.put(pre + "Type", pk.getValue().getType().toString());
        }
        int colIdx = 1;
        for (Map.Entry<String, ColumnValue> col : rowChange.getAttributeColumns().entrySet()) {
            String pre = String.format("Column.%d.", colIdx++);
            params.put(pre + "Name", col.getKey());
            params.put(pre + "Value", OTSUtil.getParameterString(col.getValue()));
            params.put(pre + "Type", col.getValue().getType().toString());
        }
        params.put("Checking", rowChange.getChecking().toString());
        if (transactionId != null && transactionId.length() > 0) {
            params.put("TransactionID", transactionId);
        }
        return params;
    }

    public void deleteData(String tableName, RowDeleteChange rowChange, String transactionId) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableName, "tableName");
        OTSUtil.ensureNameValid(tableName);
        CodingUtils.assertParameterNotNull(rowChange, "rowChange");
        if (rowChange.getPrimaryKeys().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
        }
        this.invokeNoResult(ACTION_DELETEDATA, HttpMethod.POST, this.getDeleteDataParameters(tableName, rowChange, transactionId));
    }

    private Map<String, String> getDeleteDataParameters(String tableName, RowDeleteChange rowChange, String transactionId) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("TableName", tableName);
        int pkIdx = 1;
        for (Map.Entry<String, PrimaryKeyValue> pk : rowChange.getPrimaryKeys().entrySet()) {
            String pre = String.format("PK.%d.", pkIdx++);
            params.put(pre + "Name", pk.getKey());
            params.put(pre + "Value", OTSUtil.getParameterString(pk.getValue()));
            params.put(pre + "Type", pk.getValue().getType().toString());
        }
        int colIdx = 1;
        for (String col : rowChange.getColumnNames()) {
            String colName = String.format("Column.%d.Name", colIdx++);
            params.put(colName, col);
        }
        if (transactionId != null && transactionId.length() > 0) {
            params.put("TransactionID", transactionId);
        }
        return params;
    }

    public void batchModifyData(String tableName, Collection<RowChange> rowChanges, String transactionId) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableName, "tableName");
        OTSUtil.ensureNameValid(tableName);
        CodingUtils.assertParameterNotNull(rowChanges, "rowChange");
        CodingUtils.assertStringNotNullOrEmpty(transactionId, "transactionId");
        if (rowChanges.size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("RowChangesIsEmpty"));
        }
        Map<String, String> params = this.getBatchModifyDataParameters(tableName, rowChanges, transactionId);
        this.invokeNoResult(ACTION_BATCHMODIFYDATA, HttpMethod.POST, params);
    }

    private Map<String, String> getBatchModifyDataParameters(String tableName, Collection<RowChange> rowChanges, String transactionId) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("TableName", tableName);
        int itemIndex = 1;
        for (RowChange rowChange : rowChanges) {
            RowChange rowPutChange;
            if (rowChange.getPrimaryKeys().size() == 0) {
                throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("MustSetPrimaryKey"));
            }
            String pre = String.format("Modify.%d.", itemIndex++);
            parameters.put(pre + "Type", rowChange.getModifyType());
            int pkIndex = 1;
            for (Map.Entry<String, PrimaryKeyValue> pk : rowChange.getPrimaryKeys().entrySet()) {
                String pkPre = String.format("%sPK.%d.", pre, pkIndex++);
                parameters.put(pkPre + "Name", pk.getKey());
                parameters.put(pkPre + "Value", OTSUtil.getParameterString(pk.getValue()));
                parameters.put(pkPre + "Type", pk.getValue().getType().toString());
            }
            int colIndex = 1;
            if (rowChange instanceof RowPutChange) {
                rowPutChange = (RowPutChange)rowChange;
                for (Map.Entry entry : ((RowPutChange)rowPutChange).getAttributeColumns().entrySet()) {
                    String colPre = String.format("%sColumn.%d.", pre, colIndex++);
                    parameters.put(colPre + "Name", (String)entry.getKey());
                    parameters.put(colPre + "Value", OTSUtil.getParameterString((ColumnValue)entry.getValue()));
                    parameters.put(colPre + "Type", ((ColumnValue)entry.getValue()).getType().toString());
                }
                parameters.put(pre + "Checking", ((RowPutChange)rowPutChange).getChecking().toString());
                continue;
            }
            rowPutChange = (RowDeleteChange)rowChange;
            for (String string : ((RowDeleteChange)rowPutChange).getColumnNames()) {
                String colName = String.format("%sColumn.%d.Name", pre, colIndex++);
                parameters.put(colName, string);
            }
        }
        parameters.put("TransactionID", transactionId);
        return parameters;
    }
}

