/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.comm.ResponseHandler;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.parser.JAXBResultParser;
import com.aliyun.common.parser.ResultParseException;
import com.aliyun.common.utils.ResourceManager;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.internal.OTSExceptionFactory;
import com.aliyun.openservices.ots.internal.model.ErrorResult;
import java.io.InputStream;

public class OTSErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage responseData) throws OTSException, ClientException {
        assert (responseData != null);
        if (responseData.isSuccessful()) {
            return;
        }
        InputStream errorStream = responseData.getContent();
        if (errorStream == null) {
            throw OTSExceptionFactory.createResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), null);
        }
        JAXBResultParser d = new JAXBResultParser(ErrorResult.class);
        try {
            Object obj = d.getObject(responseData);
            if (obj instanceof ErrorResult) {
                ErrorResult err = (ErrorResult)obj;
                throw OTSExceptionFactory.create(err);
            }
        }
        catch (ResultParseException e) {
            throw OTSExceptionFactory.createResponseException(ResourceManager.getInstance("common").getString("ServerReturnsUnknownError"), null);
        }
    }
}

