/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.model.ErrorResult;

public class OTSExceptionFactory {
    public static OTSException create(ErrorResult err) {
        assert (err != null);
        return new OTSException(err.Message, null, err.Code, err.RequestId, err.HostId);
    }

    public static OTSException create(String message, Throwable cause) {
        return new OTSException(message, cause);
    }

    public static OTSException create(String message, Throwable cause, String errorCode, String requestId, String hostId) {
        return new OTSException(message, cause, errorCode, requestId, hostId);
    }

    public static ClientException createResponseException(String message, Throwable cause) {
        return new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getString("ResponseInvalid") + message, cause);
    }
}

