/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.ColumnType;

public class ColumnValue {
    private ColumnType type;
    private String value;

    ColumnValue(String value, ColumnType type) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        this.value = value;
        this.type = type;
    }

    public ColumnType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public static ColumnValue fromString(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return new ColumnValue(value, ColumnType.STRING);
    }

    public static ColumnValue fromLong(long value) {
        return new ColumnValue(Long.toString(value), ColumnType.INTEGER);
    }

    public static ColumnValue fromBoolean(boolean value) {
        return new ColumnValue(Boolean.toString(value).toUpperCase(), ColumnType.BOOLEAN);
    }

    public static ColumnValue fromDouble(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("DoubleNaNNotSupported"));
        }
        return new ColumnValue(Double.toString(value), ColumnType.DOUBLE);
    }

    public String toString() {
        return this.value;
    }

    public long toLong() {
        if (this.type != ColumnType.INTEGER) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "INTEGER"));
        }
        return Long.parseLong(this.value);
    }

    public double toDouble() {
        if (this.type != ColumnType.DOUBLE) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "DOUBLE"));
        }
        Double result = Double.parseDouble(this.value);
        if (result == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        if (result == Double.NEGATIVE_INFINITY) {
            return -1.7976931348623157E308;
        }
        return result;
    }

    public boolean toBoolean() {
        if (this.type != ColumnType.BOOLEAN) {
            throw new IllegalStateException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("DateTypeIsNot", "BOOLEAN"));
        }
        return Boolean.parseBoolean(this.value);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ColumnValue)) {
            return false;
        }
        ColumnValue val = (ColumnValue)o;
        return this.type == val.type && this.value.equals(val.value);
    }

    public int hashCode() {
        return this.value.hashCode() ^ this.type.hashCode();
    }
}

