/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.AttributeColumn;
import com.aliyun.openservices.ots.model.ColumnType;
import com.aliyun.openservices.ots.model.PrimaryKey;
import com.aliyun.openservices.ots.model.PrimaryKeyType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ViewMeta {
    private String viewName;
    private int pagingKeyLen;
    @XmlElement(name="PrimaryKey")
    private List<PrimaryKey> resultPrimaryKeys;
    private Map<String, PrimaryKeyType> primaryKeys = new LinkedHashMap<String, PrimaryKeyType>();
    @XmlElement(name="Column")
    private List<AttributeColumn> resultAttributeColumns;
    private Map<String, ColumnType> attributeColumns = new LinkedHashMap<String, ColumnType>();

    public String getViewName() {
        return this.viewName;
    }

    @XmlElement(name="Name")
    public void setViewName(String viewName) {
        if (viewName == null) {
            throw new NullPointerException();
        }
        if (!OTSUtil.nameValid(viewName)) {
            throw new IllegalArgumentException();
        }
        this.viewName = viewName;
    }

    public int getPagingKeyLen() {
        return this.pagingKeyLen;
    }

    @XmlElement(name="PagingKeyLen")
    public void setPagingKeyLen(int pagingKeyLen) {
        if (pagingKeyLen < 0) {
            throw new ArithmeticException(OTSUtil.OTS_RESOURCE_MANAGER.getString("ValueLessThanZero"));
        }
        this.pagingKeyLen = pagingKeyLen;
    }

    public Map<String, PrimaryKeyType> getPrimaryKeys() {
        this.loadResultPrimaryKey();
        return Collections.unmodifiableMap(this.primaryKeys);
    }

    public void addPrimaryKey(String name, PrimaryKeyType type) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        if (!OTSUtil.nameValid(name)) {
            throw new IllegalArgumentException();
        }
        this.primaryKeys.put(name, type);
    }

    private void loadResultPrimaryKey() {
        if (this.resultPrimaryKeys != null) {
            for (PrimaryKey pk : this.resultPrimaryKeys) {
                this.primaryKeys.put(pk.Name, PrimaryKeyType.fromString(pk.Type));
            }
            this.resultPrimaryKeys = null;
        }
    }

    public Map<String, ColumnType> getAttributeColumns() {
        this.loadResultColumns();
        return Collections.unmodifiableMap(this.attributeColumns);
    }

    public void addAttributeColumn(String name, ColumnType type) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        if (!OTSUtil.nameValid(name)) {
            throw new IllegalArgumentException();
        }
        this.attributeColumns.put(name, type);
    }

    private void loadResultColumns() {
        if (this.resultAttributeColumns != null) {
            for (AttributeColumn col : this.resultAttributeColumns) {
                this.attributeColumns.put(col.Name, ColumnType.fromString(col.Type));
            }
            this.resultAttributeColumns = null;
        }
    }

    ViewMeta() {
    }

    public ViewMeta(String viewName) {
        if (viewName == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(viewName);
        this.viewName = viewName;
    }
}

