/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.common.Shard;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.loghub.client.config.LogHubConfig;
import com.aliyun.openservices.loghub.client.config.LogHubCursorPosition;

public class DebugHelper {
    public static boolean InitCheckPoint(LogHubConfig config) {
        Client client = new Client(config.getLogHubEndPoint(), config.getAccessId(), config.getAccessKey());
        if (config.isDirectModeEnabled()) {
            client.EnableDirectMode();
        }
        if (config.getStsToken() != null && !config.getStsToken().isEmpty()) {
            client.SetSecurityToken(config.getStsToken());
        }
        try {
            for (Shard s : client.ListShard(config.getProject(), config.getLogStore()).GetShards()) {
                String cursor = "";
                cursor = config.getCursorPosition() == LogHubCursorPosition.BEGIN_CURSOR ? client.GetCursor(config.getProject(), config.getLogStore(), s.GetShardId(), Consts.CursorMode.BEGIN).GetCursor() : (config.getCursorPosition() == LogHubCursorPosition.END_CURSOR ? client.GetCursor(config.getProject(), config.getLogStore(), s.GetShardId(), Consts.CursorMode.END).GetCursor() : client.GetCursor(config.getProject(), config.getLogStore(), s.GetShardId(), (long)config.GetCursorStartTime()).GetCursor());
                client.UpdateCheckPoint(config.getProject(), config.getLogStore(), config.getConsumerGroupName(), s.GetShardId(), cursor);
            }
        }
        catch (LogException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
    }
}

