/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.log.common.LogGroupData;
import com.aliyun.openservices.loghub.client.ClientFetcher;
import com.aliyun.openservices.loghub.client.DefaultLogHubCheckPointTracker;
import com.aliyun.openservices.loghub.client.FetchedLogGroup;
import com.aliyun.openservices.loghub.client.ILogHubCheckPointTracker;
import com.aliyun.openservices.loghub.client.interfaces.ILogHubProcessor;
import com.aliyun.openservices.loghub.client.interfaces.ILogHubShardListener;
import java.util.List;

public class InnerFetcherProcessor
implements ILogHubProcessor {
    private int mShardId;
    private final ClientFetcher mFetcher;
    private boolean bHasShutdown = false;

    public InnerFetcherProcessor(ClientFetcher fetcher) {
        this.mFetcher = fetcher;
    }

    @Override
    public void initialize(int shardId) {
        this.mShardId = shardId;
        ILogHubShardListener listener = this.mFetcher.getShardListener();
        if (listener != null) {
            listener.ShardAdded(this.mShardId);
        }
    }

    @Override
    public String process(List<LogGroupData> logGroups, ILogHubCheckPointTracker checkPointTracker) {
        if (logGroups.size() > 0) {
            DefaultLogHubCheckPointTracker tracker = (DefaultLogHubCheckPointTracker)checkPointTracker;
            FetchedLogGroup data = new FetchedLogGroup(this.mShardId, logGroups, tracker.getCursor());
            this.mFetcher.updateCachedData(this.mShardId, data);
        }
        return "";
    }

    @Override
    public void shutdown(ILogHubCheckPointTracker checkPointTracker) {
        if (!this.bHasShutdown) {
            this.mFetcher.cleanCachedData(this.mShardId);
            ILogHubShardListener listener = this.mFetcher.getShardListener();
            if (listener != null) {
                listener.ShardDeleted(this.mShardId);
            }
            this.bHasShutdown = true;
        }
    }
}

