/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client.config;

import com.aliyun.openservices.loghub.client.config.LogHubCursorPosition;
import java.io.Serializable;

public class LogHubConfig
implements Serializable {
    private static final long serialVersionUID = -460559812263406428L;
    public static final long DEFAULT_DATA_FETCH_INTERVAL_MS = 200L;
    private String mConsumerGroupName;
    private String mWorkerInstanceName;
    private String mLogHubEndPoint;
    private String mProject;
    private String mLogStore;
    private String mAccessId;
    private String mAccessKey;
    private LogHubCursorPosition mCursorPosition;
    private int mLoghubCursorStartTime = 0;
    private long mDataFetchIntervalMillis;
    private long mHeartBeatIntervalMillis = 20000L;
    private boolean mConsumeInOrder = false;
    private String mStsToken = null;
    private boolean mUseDirectMode = false;

    public LogHubConfig(String consumerGroupName, String consumerName, String loghubEndPoint, String project, String logStore, String accessId, String accessKey, ConsumePosition position) {
        this.mConsumerGroupName = consumerGroupName;
        this.mWorkerInstanceName = consumerName;
        this.mLogHubEndPoint = loghubEndPoint;
        this.mProject = project;
        this.mLogStore = logStore;
        this.mAccessId = accessId;
        this.mAccessKey = accessKey;
        this.mDataFetchIntervalMillis = 200L;
        this.mHeartBeatIntervalMillis = 30000L;
        this.mConsumeInOrder = false;
        this.mUseDirectMode = false;
        if (position == ConsumePosition.BEGIN_CURSOR) {
            this.mCursorPosition = LogHubCursorPosition.BEGIN_CURSOR;
        } else if (position == ConsumePosition.END_CURSOR) {
            this.mCursorPosition = LogHubCursorPosition.END_CURSOR;
        }
    }

    public LogHubConfig(String consumerGroupName, String consumerName, String loghubEndPoint, String project, String logStore, String accessId, String accessKey, int consumerStartTimeInSeconds) {
        this.mConsumerGroupName = consumerGroupName;
        this.mWorkerInstanceName = consumerName;
        this.mLogHubEndPoint = loghubEndPoint;
        this.mProject = project;
        this.mLogStore = logStore;
        this.mAccessId = accessId;
        this.mAccessKey = accessKey;
        this.mDataFetchIntervalMillis = 200L;
        this.mHeartBeatIntervalMillis = 30000L;
        this.mConsumeInOrder = false;
        this.mUseDirectMode = false;
        this.mCursorPosition = LogHubCursorPosition.SPECIAL_TIMER_CURSOR;
        this.mLoghubCursorStartTime = consumerStartTimeInSeconds;
    }

    @Deprecated
    public LogHubConfig(String consumerGroupName, String consumerName, String loghubEndPoint, String project, String logStore, String accessId, String accessKey, LogHubCursorPosition cursorPosition, long heartBeatIntervalMillis, boolean consumeInOrder, boolean userDirectMode) {
        this.mConsumerGroupName = consumerGroupName;
        this.mWorkerInstanceName = consumerName;
        this.mLogHubEndPoint = loghubEndPoint;
        this.mProject = project;
        this.mLogStore = logStore;
        this.mAccessId = accessId;
        this.mAccessKey = accessKey;
        this.mCursorPosition = cursorPosition;
        this.mDataFetchIntervalMillis = 200L;
        this.mHeartBeatIntervalMillis = heartBeatIntervalMillis;
        this.mConsumeInOrder = consumeInOrder;
        this.mUseDirectMode = userDirectMode;
    }

    @Deprecated
    public LogHubConfig(String consumerGroupName, String consumerName, String loghubEndPoint, String project, String logStore, String accessId, String accessKey, LogHubCursorPosition cursorPosition, long heartBeatIntervalMillis, boolean consumeInOrder) {
        this(consumerGroupName, consumerName, loghubEndPoint, project, logStore, accessId, accessKey, cursorPosition, heartBeatIntervalMillis, consumeInOrder, false);
    }

    @Deprecated
    public LogHubConfig(String consumerGroupName, String consumerName, String loghubEndPoint, String project, String logStore, String accessId, String accessKey, int start_time, long heartBeatIntervalMillis, boolean consumeInOrder) {
        this.mConsumerGroupName = consumerGroupName;
        this.mWorkerInstanceName = consumerName;
        this.mLogHubEndPoint = loghubEndPoint;
        this.mProject = project;
        this.mLogStore = logStore;
        this.mAccessId = accessId;
        this.mAccessKey = accessKey;
        this.mCursorPosition = LogHubCursorPosition.SPECIAL_TIMER_CURSOR;
        this.mLoghubCursorStartTime = start_time;
        this.mDataFetchIntervalMillis = 200L;
        this.mHeartBeatIntervalMillis = heartBeatIntervalMillis;
        this.mConsumeInOrder = consumeInOrder;
    }

    @Deprecated
    public LogHubConfig(String consumerGroupName, String consumerName, String loghubEndPoint, String project, String logStore, String accessId, String accessKey, LogHubCursorPosition cursorPosition, long heartBeatIntervalMillis, boolean consumeInOrder, String stsToken) {
        this(consumerGroupName, consumerName, loghubEndPoint, project, logStore, accessId, accessKey, cursorPosition, heartBeatIntervalMillis, consumeInOrder);
        this.mStsToken = stsToken;
    }

    @Deprecated
    public LogHubConfig(String consumerGroupName, String consumerName, String loghubEndPoint, String project, String logStore, String accessId, String accessKey, int start_time, long heartBeatIntervalMillis, boolean consumeInOrder, String stsToken) {
        this(consumerGroupName, consumerName, loghubEndPoint, project, logStore, accessId, accessKey, start_time, heartBeatIntervalMillis, consumeInOrder);
        this.mStsToken = stsToken;
    }

    public String getStsToken() {
        return this.mStsToken;
    }

    public void setStsToken(String mStsToken) {
        this.mStsToken = mStsToken;
    }

    public long getDataFetchIntervalMillis() {
        return this.mDataFetchIntervalMillis;
    }

    public void setDataFetchIntervalMillis(long dataFetchIntervalMillis) {
        this.mDataFetchIntervalMillis = dataFetchIntervalMillis;
    }

    public boolean isConsumeInOrder() {
        return this.mConsumeInOrder;
    }

    public void setConsumeInOrder(boolean order) {
        this.mConsumeInOrder = order;
    }

    public long getHeartBeatIntervalMillis() {
        return this.mHeartBeatIntervalMillis;
    }

    public void setHeartBeatIntervalMillis(long heartBeatIntervalMillis) {
        this.mHeartBeatIntervalMillis = heartBeatIntervalMillis;
    }

    public String getConsumerGroupName() {
        return this.mConsumerGroupName;
    }

    public String getConsumerName() {
        return this.mWorkerInstanceName;
    }

    @Deprecated
    public String getWorkerInstanceName() {
        return this.mWorkerInstanceName;
    }

    public String getLogHubEndPoint() {
        return this.mLogHubEndPoint;
    }

    public String getProject() {
        return this.mProject;
    }

    public String getLogStore() {
        return this.mLogStore;
    }

    public String getAccessId() {
        return this.mAccessId;
    }

    public String getAccessKey() {
        return this.mAccessKey;
    }

    public LogHubCursorPosition getCursorPosition() {
        return this.mCursorPosition;
    }

    public int GetCursorStartTime() {
        return this.mLoghubCursorStartTime;
    }

    @Deprecated
    public void EnableDirectMode() {
        this.mUseDirectMode = true;
    }

    @Deprecated
    public void DisableDirectMode() {
        this.mUseDirectMode = false;
    }

    public void SetDirectMode(boolean enable) {
        this.mUseDirectMode = enable;
    }

    public boolean isDirectModeEnabled() {
        return this.mUseDirectMode;
    }

    public static enum ConsumePosition {
        BEGIN_CURSOR,
        END_CURSOR;

    }
}

