/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.common.ConsumerGroup;
import com.aliyun.openservices.log.common.ConsumerGroupShardCheckPoint;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.response.BatchGetLogResponse;
import com.aliyun.openservices.loghub.client.excpetions.LogHubCheckPointException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class LogHubClientAdapter {
    private final Client mClient;
    private final String mProject;
    private final String mStream;
    private final String mConsumerGroup;
    private final String mConsumer;
    private final String mUserAgent;
    private static final Logger logger = Logger.getLogger(LogHubClientAdapter.class);

    public LogHubClientAdapter(String endPoint, String accessKeyId, String accessKey, String project, String stream, String consumerGroup, String consumer) {
        this.mClient = new Client(endPoint, accessKeyId, accessKey);
        this.mProject = project;
        this.mStream = stream;
        this.mConsumerGroup = consumerGroup;
        this.mConsumer = consumer;
        this.mUserAgent = "[consumer-group-java]" + consumerGroup;
        this.mClient.setUserAgent(this.mUserAgent);
    }

    public void CreateConsumerGroup(int timeoutInSec, boolean inOrder) throws LogException {
        this.mClient.CreateConsumerGroup(this.mProject, this.mStream, new ConsumerGroup(this.mConsumerGroup, timeoutInSec, inOrder));
    }

    public ConsumerGroup GetConsumerGroup() throws LogException {
        for (ConsumerGroup consumerGroup : this.mClient.ListConsumerGroup(this.mProject, this.mStream).GetConsumerGroups()) {
            if (consumerGroup.getConsumerGroupName().compareTo(this.mConsumerGroup) != 0) continue;
            return consumerGroup;
        }
        return null;
    }

    public boolean HeartBeat(ArrayList<Integer> shards, ArrayList<Integer> response) {
        response.clear();
        try {
            response.addAll(this.mClient.HeartBeat(this.mProject, this.mStream, this.mConsumerGroup, this.mConsumer, shards).GetShards());
            return true;
        }
        catch (LogException e) {
            logger.warn((Object)(e.GetErrorCode() + ": " + e.GetErrorMessage()));
            return false;
        }
    }

    public void UpdateCheckPoint(int shard, String consumer, String checkpoint) throws LogException {
        this.mClient.UpdateCheckPoint(this.mProject, this.mStream, this.mConsumerGroup, consumer, shard, checkpoint);
    }

    public String GetCheckPoint(int shard) throws LogException, LogHubCheckPointException {
        ArrayList checkPoints = this.mClient.GetCheckPoint(this.mProject, this.mStream, this.mConsumerGroup, shard).GetCheckPoints();
        if (checkPoints.size() > 0) {
            return ((ConsumerGroupShardCheckPoint)checkPoints.get(0)).getCheckPoint();
        }
        throw new LogHubCheckPointException("fail to get shard checkpoint");
    }

    public String GetCursor(int shard, Consts.CursorMode mode) throws LogException {
        return this.mClient.GetCursor(this.mProject, this.mStream, shard, mode).GetCursor();
    }

    public String GetCursor(int shard, long time) throws LogException {
        return this.mClient.GetCursor(this.mProject, this.mStream, shard, time).GetCursor();
    }

    public BatchGetLogResponse BatchGetLogs(int shard, int lines, String cursor) throws LogException {
        return this.mClient.BatchGetLog(this.mProject, this.mStream, shard, lines, cursor);
    }
}

