/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.common.ConsumerGroup;
import com.aliyun.openservices.log.common.ConsumerGroupShardCheckPoint;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.aliyun.openservices.log.response.BatchGetLogResponse;
import com.aliyun.openservices.log.response.ConsumerGroupCheckPointResponse;
import com.aliyun.openservices.log.response.ListConsumerGroupResponse;
import com.aliyun.openservices.loghub.client.config.LogHubConfig;
import com.aliyun.openservices.loghub.client.config.LogHubCursorPosition;
import com.aliyun.openservices.loghub.client.exceptions.LogHubClientWorkerException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHubClientAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(LogHubClientAdapter.class);
    private Client client;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final String project;
    private final String logstore;
    private final String consumerGroup;
    private final String consumer;
    private final String userAgent;
    private final LogHubConfig config;

    LogHubClientAdapter(LogHubConfig config) {
        this.config = config;
        this.project = config.getProject();
        this.logstore = config.getLogStore();
        this.consumerGroup = config.getConsumerGroup();
        this.consumer = config.getConsumer();
        this.userAgent = LogHubClientAdapter.getOrCreateUserAgent(config);
        this.client = this.createClient(config.getEndpoint(), config.getAccessId(), config.getAccessKey(), config.getStsToken());
    }

    private Client createClient(String endpoint, String accessKeyId, String accessKey, String stsToken) {
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(Consts.HTTP_CONNECT_MAX_COUNT);
        clientConfig.setConnectionTimeout(Consts.HTTP_CONNECT_TIME_OUT);
        clientConfig.setSocketTimeout(Consts.HTTP_SEND_TIME_OUT);
        clientConfig.setUseReaper(true);
        Client client = new Client(endpoint, accessKeyId, accessKey, clientConfig);
        if (stsToken != null) {
            client.setSecurityToken(stsToken);
        }
        client.setUserAgent(this.userAgent);
        client.setUseDirectMode(this.config.isDirectModeEnabled());
        return client;
    }

    public String getProject() {
        return this.project;
    }

    public String getLogstore() {
        return this.logstore;
    }

    public String getConsumer() {
        return this.consumer;
    }

    private static String getOrCreateUserAgent(LogHubConfig config) {
        if (config.getUserAgent() != null) {
            return config.getUserAgent();
        }
        return "Consumer-Library-" + config.getConsumerGroup() + "/" + config.getConsumer();
    }

    public void SwitchClient(String endpoint, String accessKeyId, String accessKey, String stsToken) {
        this.lock.writeLock().lock();
        if (this.client != null) {
            this.client.shutdown();
        }
        this.client = this.createClient(endpoint, accessKeyId, accessKey, stsToken);
        this.lock.writeLock().unlock();
    }

    private ConsumerGroup getConsumerGroup() throws Exception {
        ListConsumerGroupResponse response;
        this.lock.readLock().lock();
        try {
            response = this.client.ListConsumerGroup(this.project, this.logstore);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (response != null) {
            for (ConsumerGroup item : response.GetConsumerGroups()) {
                if (!item.getConsumerGroupName().equalsIgnoreCase(this.consumerGroup)) continue;
                return item;
            }
        }
        return null;
    }

    void createConsumerGroupIfNotExist(LogHubConfig config) throws LogHubClientWorkerException {
        ConsumerGroup existed = null;
        try {
            existed = this.getConsumerGroup();
        }
        catch (Exception ex) {
            LOG.warn("Unable to check if consumer exist {}", (Object)ex.getMessage());
        }
        ConsumerGroup toCreate = new ConsumerGroup(this.consumerGroup, config.getTimeoutInSeconds(), config.isConsumeInOrder());
        if (existed == null) {
            LOG.info("Consumer group not found, need to create it.");
            this.lock.readLock().lock();
            try {
                this.client.CreateConsumerGroup(this.project, this.logstore, toCreate);
            }
            catch (LogException ex) {
                throw new LogHubClientWorkerException("error occurs when update consumer group, errorCode: " + ex.GetErrorCode() + ", errorMessage: " + ex.GetErrorMessage());
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        if (existed.getTimeout() != config.getTimeoutInSeconds() || existed.isInOrder() != config.isConsumeInOrder()) {
            LOG.info("Consumer group config is different with existing consumer group, need to update it.");
            this.lock.readLock().lock();
            try {
                this.client.UpdateConsumerGroup(this.project, this.logstore, this.consumerGroup, config.isConsumeInOrder(), config.getTimeoutInSeconds());
            }
            catch (LogException ex) {
                throw new LogHubClientWorkerException("error occurs when update consumer group, errorCode: " + ex.GetErrorCode() + ", errorMessage: " + ex.GetErrorMessage());
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    public void CreateConsumerGroup(int timeoutInSec, boolean inOrder) throws LogException {
        this.lock.readLock().lock();
        try {
            this.client.CreateConsumerGroup(this.project, this.logstore, new ConsumerGroup(this.consumerGroup, timeoutInSec, inOrder));
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void UpdateConsumerGroup(int timeoutInSec, boolean inOrder) throws LogException {
        this.lock.readLock().lock();
        try {
            this.client.UpdateConsumerGroup(this.project, this.logstore, this.consumerGroup, inOrder, timeoutInSec);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<Integer> HeartBeat(ArrayList<Integer> shards) throws LogException {
        this.lock.readLock().lock();
        try {
            List list = this.client.HeartBeat(this.project, this.logstore, this.consumerGroup, this.consumer, shards).getShards();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UpdateCheckPoint(int shard, String consumer, String checkpoint) throws LogException {
        this.lock.readLock().lock();
        try {
            this.client.UpdateCheckPoint(this.project, this.logstore, this.consumerGroup, consumer, shard, checkpoint);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String GetCheckPoint(int shard) throws LogException {
        ConsumerGroupCheckPointResponse response;
        this.lock.readLock().lock();
        try {
            response = this.client.GetCheckPoint(this.project, this.logstore, this.consumerGroup, shard);
        }
        finally {
            this.lock.readLock().unlock();
        }
        List checkpoints = response.getCheckPoints();
        if (checkpoints == null || checkpoints.isEmpty()) {
            throw new LogException("CheckpointNotExist", "Checkpoint not found for shard " + shard, response.GetRequestId());
        }
        return ((ConsumerGroupShardCheckPoint)checkpoints.get(0)).getCheckPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetCursor(int shard, Consts.CursorMode mode) throws LogException {
        this.lock.readLock().lock();
        try {
            String string = this.client.GetCursor(this.project, this.logstore, shard, mode).GetCursor();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getCursor(int shard, LogHubCursorPosition position, long startTime) throws LogException {
        if (position.equals((Object)LogHubCursorPosition.BEGIN_CURSOR)) {
            return this.GetCursor(shard, Consts.CursorMode.BEGIN);
        }
        if (position.equals((Object)LogHubCursorPosition.END_CURSOR)) {
            return this.GetCursor(shard, Consts.CursorMode.END);
        }
        return this.GetCursor(shard, startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetCursor(int shard, long time) throws LogException {
        this.lock.readLock().lock();
        try {
            String string = this.client.GetCursor(this.project, this.logstore, shard, time).GetCursor();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchGetLogResponse BatchGetLogs(int shard, int lines, String cursor) throws LogException {
        this.lock.readLock().lock();
        try {
            BatchGetLogResponse batchGetLogResponse = this.client.BatchGetLog(this.project, this.logstore, shard, lines, cursor);
            return batchGetLogResponse;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

