/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.loghub.client.LogHubClientAdapter;
import com.aliyun.openservices.loghub.client.LogThreadFactory;
import com.aliyun.openservices.loghub.client.LoghubClientUtil;
import com.aliyun.openservices.loghub.client.config.LogHubConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHubHeartBeat {
    private static final Logger LOG = LoggerFactory.getLogger(LogHubHeartBeat.class);
    private static final long STOP_TIMEOUT_SECS = 2L;
    private ScheduledExecutorService executorService;
    private final LogHubClientAdapter client;
    private final long intervalMills;
    private final int timeoutSecs;
    private Set<Integer> heldShards;
    private HashSet<Integer> heartShards;
    private long lastSuccessTime;

    public LogHubHeartBeat(LogHubClientAdapter client, LogHubConfig config) {
        this.client = client;
        this.intervalMills = config.getHeartBeatIntervalMillis();
        this.timeoutSecs = config.getTimeoutInSeconds();
        this.heldShards = new HashSet<Integer>();
        this.heartShards = new HashSet();
    }

    public void start() {
        this.executorService = Executors.newScheduledThreadPool(1, new LogThreadFactory());
        this.executorService.scheduleWithFixedDelay(new HeartBeatRunnable(), 0L, this.intervalMills, TimeUnit.MILLISECONDS);
        LOG.info("Background heartbeat thread started, interval {}", (Object)this.intervalMills);
    }

    public void stop() {
        LoghubClientUtil.shutdownAndAwaitTermination(this.executorService, 2L);
    }

    public synchronized List<Integer> getHeldShards() {
        return new ArrayList<Integer>(this.heldShards);
    }

    public synchronized void removeHeartShard(int shard) {
        this.heartShards.remove(shard);
    }

    private synchronized void heartBeat() {
        block2: {
            long currentNow = System.currentTimeMillis();
            try {
                List<Integer> shards = this.client.HeartBeat(new ArrayList<Integer>(this.heartShards));
                LOG.debug("Heartbeat success, response shards: {}", shards);
                this.heldShards = new HashSet<Integer>(shards);
                this.heartShards.addAll(shards);
                this.lastSuccessTime = currentNow;
            }
            catch (Exception ex) {
                LOG.error("Error sending heartbeat, project {}, logstore {}, consumer {}", new Object[]{this.client.getProject(), this.client.getLogstore(), this.client.getConsumer(), ex});
                if (currentNow - this.lastSuccessTime <= (long)(this.timeoutSecs * 1000) + this.intervalMills) break block2;
                this.heldShards.clear();
                LOG.warn("Heartbeat failed since {}, clear held shards", (Object)this.lastSuccessTime);
            }
        }
    }

    public synchronized void unload(int shard) {
        this.heldShards.remove(shard);
    }

    private class HeartBeatRunnable
    implements Runnable {
        private HeartBeatRunnable() {
        }

        @Override
        public void run() {
            LogHubHeartBeat.this.heartBeat();
        }
    }
}

