/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.log.common.LogGroupData;
import com.aliyun.openservices.loghub.client.DefaultLogHubCheckPointTracker;
import com.aliyun.openservices.loghub.client.ITask;
import com.aliyun.openservices.loghub.client.ProcessTaskResult;
import com.aliyun.openservices.loghub.client.TaskResult;
import com.aliyun.openservices.loghub.client.interfaces.ILogHubProcessor;
import com.aliyun.openservices.loghub.client.throttle.ResourceBarrier;
import java.util.List;

public class ProcessTask
implements ITask {
    private ILogHubProcessor processor;
    private List<LogGroupData> chunk;
    private DefaultLogHubCheckPointTracker checkPointTracker;
    private int rawSize;
    private ResourceBarrier resourceBarrier;

    public ProcessTask(ILogHubProcessor processor, List<LogGroupData> logGroups, DefaultLogHubCheckPointTracker checkPointTracker, int rawSize, ResourceBarrier resourceBarrier) {
        this.processor = processor;
        this.chunk = logGroups;
        this.checkPointTracker = checkPointTracker;
        this.rawSize = rawSize;
        this.resourceBarrier = resourceBarrier;
    }

    @Override
    public TaskResult call() {
        String checkpoint;
        try {
            checkpoint = this.processor.process(this.chunk, this.checkPointTracker);
            this.checkPointTracker.flushCheckpointIfNeeded();
        }
        catch (Exception e) {
            this.resourceBarrier.release(this.rawSize);
            return new TaskResult(e);
        }
        this.resourceBarrier.release(this.rawSize);
        return new ProcessTaskResult(checkpoint);
    }
}

