/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client.config;

import com.aliyun.openservices.loghub.client.config.LogHubCursorPosition;
import java.io.Serializable;

public class LogHubConfig
implements Serializable {
    private static final long serialVersionUID = -460559812263406428L;
    private static final long DEFAULT_FETCH_INTERVAL_MS = 200L;
    private static final long DEFAULT_COMMIT_INTERVAL_MS = 60000L;
    private static final long DEFAULT_HEARTBEAT_INTERVAL = 5000L;
    private static final int DEFAULT_TIMEOUT_SEC = 60;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private String consumerGroup;
    private String consumer;
    private String endpoint;
    private String project;
    private String logstore;
    private String accessId;
    private String accessKey;
    private LogHubCursorPosition initialPosition;
    private int startTimestamp = 0;
    private long fetchIntervalMillis = 200L;
    private long heartbeatIntervalMillis = 5000L;
    private boolean consumeInOrder = false;
    private String stsToken = null;
    private boolean directModeEnabled = false;
    private boolean autoCommitEnabled = true;
    private boolean unloadAfterCommitEnabled = false;
    private long autoCommitIntervalMs = 60000L;
    private int batchSize = 1000;
    private int timeoutInSeconds = 60;
    private int maxInProgressingDataSizeInMB = 0;
    private String userAgent;

    private LogHubConfig(String consumerGroup, String consumer, String endpoint, String project, String logstore, String accessId, String accessKey) {
        this.consumerGroup = consumerGroup;
        this.consumer = consumer;
        this.endpoint = endpoint;
        this.project = project;
        this.logstore = logstore;
        this.accessId = accessId;
        this.accessKey = accessKey;
    }

    public LogHubConfig(String consumerGroup, String consumer, String endpoint, String project, String logstore, String accessId, String accessKey, ConsumePosition position) {
        this(consumerGroup, consumer, endpoint, project, logstore, accessId, accessKey);
        this.initialPosition = LogHubConfig.convertPosition(position);
    }

    private static LogHubCursorPosition convertPosition(ConsumePosition position) {
        switch (position) {
            case BEGIN_CURSOR: {
                return LogHubCursorPosition.BEGIN_CURSOR;
            }
            case END_CURSOR: {
                return LogHubCursorPosition.END_CURSOR;
            }
        }
        throw new IllegalArgumentException("Invalid initial position: " + (Object)((Object)position));
    }

    public LogHubConfig(String consumerGroup, String consumer, String endpoint, String project, String logstore, String accessId, String accessKey, int startTimestamp) {
        this(consumerGroup, consumer, endpoint, project, logstore, accessId, accessKey);
        this.initialPosition = LogHubCursorPosition.SPECIAL_TIMER_CURSOR;
        this.startTimestamp = startTimestamp;
    }

    public LogHubConfig(String consumerGroup, String consumer, String endpoint, String project, String logstore, String accessId, String accessKey, ConsumePosition position, int batchSize) {
        this(consumerGroup, consumer, endpoint, project, logstore, accessId, accessKey);
        this.initialPosition = LogHubConfig.convertPosition(position);
        this.batchSize = batchSize;
    }

    public LogHubConfig(String consumerGroup, String consumer, String endpoint, String project, String logstore, String accessId, String accessKey, int startTimestamp, int batchSize) {
        this(consumerGroup, consumer, endpoint, project, logstore, accessId, accessKey);
        this.initialPosition = LogHubCursorPosition.SPECIAL_TIMER_CURSOR;
        this.startTimestamp = startTimestamp;
        this.batchSize = batchSize;
    }

    @Deprecated
    public LogHubConfig(String consumerGroup, String consumer, String endpoint, String project, String logstore, String accessId, String accessKey, int startTime, long heartBeatIntervalMillis, boolean consumeInOrder) {
        this(consumerGroup, consumer, endpoint, project, logstore, accessId, accessKey);
        this.initialPosition = LogHubCursorPosition.SPECIAL_TIMER_CURSOR;
        this.startTimestamp = startTime;
        this.heartbeatIntervalMillis = heartBeatIntervalMillis;
        this.consumeInOrder = consumeInOrder;
    }

    @Deprecated
    public LogHubConfig(String consumerGroup, String consumer, String endpoint, String project, String logStore, String accessId, String accessKey, int startTime, long heartBeatIntervalMillis, boolean consumeInOrder, String stsToken) {
        this(consumerGroup, consumer, endpoint, project, logStore, accessId, accessKey, startTime, heartBeatIntervalMillis, consumeInOrder);
        this.stsToken = stsToken;
    }

    public String getStsToken() {
        return this.stsToken;
    }

    public void setStsToken(String stsToken) {
        this.stsToken = stsToken;
    }

    public long getFetchIntervalMillis() {
        return this.fetchIntervalMillis;
    }

    public void setFetchIntervalMillis(long fetchIntervalMillis) {
        this.fetchIntervalMillis = fetchIntervalMillis;
    }

    public boolean isConsumeInOrder() {
        return this.consumeInOrder;
    }

    public void setConsumeInOrder(boolean order) {
        this.consumeInOrder = order;
    }

    public long getHeartBeatIntervalMillis() {
        return this.heartbeatIntervalMillis;
    }

    public void setHeartBeatIntervalMillis(long heartBeatIntervalMillis) {
        this.heartbeatIntervalMillis = heartBeatIntervalMillis;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public String getConsumer() {
        return this.consumer;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getProject() {
        return this.project;
    }

    public String getLogStore() {
        return this.logstore;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public LogHubCursorPosition getCursorPosition() {
        return this.initialPosition;
    }

    public int GetCursorStartTime() {
        return this.startTimestamp;
    }

    public void setDirectModeEnabled(boolean directModeEnabled) {
        this.directModeEnabled = directModeEnabled;
    }

    public boolean isDirectModeEnabled() {
        return this.directModeEnabled;
    }

    public int getMaxFetchLogGroupSize() {
        return this.batchSize;
    }

    public void setMaxFetchLogGroupSize(int maxFetchLogGroupSize) {
        this.batchSize = maxFetchLogGroupSize;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isAutoCommitEnabled() {
        return this.autoCommitEnabled;
    }

    public void setAutoCommitEnabled(boolean autoCommitEnabled) {
        this.autoCommitEnabled = autoCommitEnabled;
    }

    public long getAutoCommitIntervalMs() {
        return this.autoCommitIntervalMs;
    }

    public void setAutoCommitIntervalMs(long autoCommitIntervalMs) {
        this.autoCommitIntervalMs = autoCommitIntervalMs;
    }

    public boolean isUnloadAfterCommitEnabled() {
        return this.unloadAfterCommitEnabled;
    }

    public void setUnloadAfterCommitEnabled(boolean unloadAfterCommitEnabled) {
        this.unloadAfterCommitEnabled = unloadAfterCommitEnabled;
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public int getMaxInProgressingDataSizeInMB() {
        return this.maxInProgressingDataSizeInMB;
    }

    public void setMaxInProgressingDataSizeInMB(int maxInProgressingDataSizeInMB) {
        this.maxInProgressingDataSizeInMB = maxInProgressingDataSizeInMB;
    }

    public static enum ConsumePosition {
        BEGIN_CURSOR,
        END_CURSOR;

    }
}

