/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.auth;

import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.auth.StsCredentials;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentials;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.utils.HttpTinyClient;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class RamRoleService {
    public static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    private static final String URL_ECS_RAMROLE = "http://100.100.100.200/latest/meta-data/Ram/security-credentials/";
    private static final long DEFAULT_UPDATE_BUFFER_TIME = 108000000L;
    private static final long MIN_UPDATE_INTERVAL = 5000L;
    private static final long HTTP_TIMEOUT = 3000L;
    private final String ramRoleName;
    private final SessionCredentials sessionCredentials;
    private final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ONSClient-UpdateTokenByRamRoleThread");
        }
    });

    public RamRoleService(String ramRoleName, SessionCredentials sessionCredentials) {
        this.ramRoleName = ramRoleName.trim();
        this.sessionCredentials = sessionCredentials;
        this.updateStsCredentials(ramRoleName);
    }

    private void updateStsCredentials(String ramRoleName) {
        StsCredentials stsCredentials = this.fetchStsCredentialsByRamRole(ramRoleName);
        this.sessionCredentials.setAccessKey(stsCredentials.getAccessKeyId());
        this.sessionCredentials.setSecretKey(stsCredentials.getAccessKeySecret());
        this.sessionCredentials.setSecurityToken(stsCredentials.getSecurityToken());
        LOGGER.info("update sts credentials success. ramRoleName=" + ramRoleName);
        this.addUpdateTimerTask(stsCredentials);
    }

    private void addUpdateTimerTask(final StsCredentials stsCredentials) {
        long now = System.currentTimeMillis();
        long interval = stsCredentials.getExpiration() - now;
        long delay = 5000L;
        delay = interval > 108000000L ? stsCredentials.getExpiration() - now - 108000000L : Math.max(5000L, (stsCredentials.getExpiration() - now) / 2L);
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    RamRoleService.this.updateStsCredentials(stsCredentials.getRamRoleName());
                }
                catch (Exception e) {
                    LOGGER.error("add update sts credentials timer task error.", e);
                }
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    private StsCredentials fetchStsCredentialsByRamRole(String ramRoleName) {
        String responseStr = null;
        try {
            HttpTinyClient.HttpResult result = HttpTinyClient.httpGet(URL_ECS_RAMROLE + ramRoleName, null, null, "UTF-8", 3000L);
            if (200 != result.code || null == result.content || "".equals(result.content)) {
                LOGGER.error("fetch sts credentials by ramRole error. ramRole=" + ramRoleName);
                throw new ONSClientException("fetch sts credentials by ram role[ " + ramRoleName + " ] error. please set right ram role");
            }
            responseStr = result.content;
            JSONObject jsonObject = JSONObject.parseObject(responseStr);
            StsCredentials stsCredentials = new StsCredentials();
            stsCredentials.setRamRoleName(ramRoleName);
            stsCredentials.setAccessKeyId(jsonObject.getString("AccessKeyId"));
            stsCredentials.setAccessKeySecret(jsonObject.getString("AccessKeySecret"));
            stsCredentials.setSecurityToken(jsonObject.getString("SecurityToken"));
            SimpleDateFormat utcFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            utcFormater.setTimeZone(TimeZone.getTimeZone("UTC"));
            stsCredentials.setExpiration(utcFormater.parse(jsonObject.getString("Expiration")).getTime());
            return stsCredentials;
        }
        catch (JSONException e) {
            LOGGER.error("fetch sts credentials by ram role error. ramRole=" + ramRoleName + ", response=" + responseStr, e);
            throw new ONSClientException("fetch sts credentials by ram role[ " + ramRoleName + " ] error. please set right ram role");
        }
        catch (Exception e) {
            LOGGER.error("fetch sts credentials by ram role error. ramRole=" + ramRoleName, e);
            throw new ONSClientException("fetch sts credentials by ram role[ " + ramRoleName + " ] error. please set right ram role");
        }
    }
}

