/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.TlsSystemConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.LanguageCode;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ClientConfig {
    public static final String SEND_MESSAGE_WITH_VIP_CHANNEL_PROPERTY = "com.rocketmq.sendMessageWithVIPChannel";
    public static final String SOCKS_PROXY_JSON = "com.rocketmq.socksProxyJson";
    public static final String DECODE_READ_BODY = "com.rocketmq.read.body";
    public static final String DECODE_DECOMPRESS_BODY = "com.rocketmq.decompress.body";
    public static final String AUTO_CLEAN_NO_ROUTE_TOPIC = "com.rocketmq.autoclean.noroute.topic";
    public static final String CLIENT_CALLBACK_EXECUTOR_THREAD_NUMS = "client.callback.executor.thread.nums";
    private String namesrvAddr = System.getProperty("rocketmq.namesrv.addr", System.getenv("NAMESRV_ADDR"));
    private String clientIP = RemotingUtil.getLocalAddress();
    private String instanceName = System.getProperty("rocketmq.client.name", "DEFAULT");
    protected String namespace;
    private int clientCallbackExecutorThreads = Integer.parseInt(System.getProperty("client.callback.executor.thread.nums", String.valueOf(Runtime.getRuntime().availableProcessors())));
    private int pollNameServerInterval = 30000;
    private int updateConsumeQueueOffsetInterval = 5000;
    private int heartbeatBrokerInterval = 30000;
    private int persistConsumerOffsetInterval = 5000;
    private boolean fetchRemoteClientConfigEnable = false;
    private int clientConfigInterval = 60000;
    private int detectBrokerInterval = 5000;
    private int detectTimeout = 200;
    private int detectInterval = 2000;
    private long pullTimeDelayMillsWhenException = 1000L;
    private boolean unitMode = false;
    private String unitName;
    private boolean vipChannelEnabled = Boolean.parseBoolean(System.getProperty("com.rocketmq.sendMessageWithVIPChannel", "true"));
    private boolean decodeReadBody = Boolean.parseBoolean(System.getProperty("com.rocketmq.read.body", "true"));
    private boolean decodeDecompressBody = Boolean.parseBoolean(System.getProperty("com.rocketmq.decompress.body", "true"));
    private boolean autoCleanTopicRouteNotFound = Boolean.parseBoolean(System.getProperty("com.rocketmq.autoclean.noroute.topic", "false"));
    private boolean recordApiStats = false;
    private boolean disableCallbackExecutor = false;
    private boolean disableNettyWorkerGroup = false;
    private boolean sendLatencyEnable = true;
    private boolean startDetectorEnable = true;
    private boolean useTLS = TlsSystemConfig.tlsEnable;
    private String sockProxyJson = System.getProperty("com.rocketmq.socksProxyJson", "{}");
    private LanguageCode language = LanguageCode.JAVA;

    public String buildMQClientId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClientIP());
        sb.append("@");
        sb.append(this.getInstanceName());
        if (!UtilAll.isBlank(this.unitName)) {
            sb.append("@");
            sb.append(this.unitName);
        }
        return sb.toString();
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void changeInstanceNameToPID() {
        if ("DEFAULT".equals(this.instanceName)) {
            this.instanceName = String.valueOf(UtilAll.getPid());
        }
    }

    public String withNamespace(String resource) {
        return NamespaceUtil.wrapNamespace(this.getNamespace(), resource);
    }

    public Set<String> withNamespace(Set<String> resourceSet) {
        HashSet<String> resourceWithNamespace = new HashSet<String>();
        for (String resource : resourceSet) {
            resourceWithNamespace.add(this.withNamespace(resource));
        }
        return resourceWithNamespace;
    }

    public String withoutNamespace(String resource) {
        return NamespaceUtil.withoutNamespace(resource, this.getNamespace());
    }

    public Set<String> withoutNamespace(Set<String> resourceSet) {
        HashSet<String> resourceWithoutNamespace = new HashSet<String>();
        for (String resource : resourceSet) {
            resourceWithoutNamespace.add(this.withoutNamespace(resource));
        }
        return resourceWithoutNamespace;
    }

    public MessageQueue queueWithNamespace(MessageQueue queue) {
        if (StringUtils.isEmpty(this.getNamespace())) {
            return queue;
        }
        return new MessageQueue(this.withNamespace(queue.getTopic()), queue.getBrokerName(), queue.getQueueId(), queue.getQueueGroupId(), queue.isMainQueue());
    }

    public Collection<MessageQueue> queuesWithNamespace(Collection<MessageQueue> queues) {
        if (StringUtils.isEmpty(this.getNamespace())) {
            return queues;
        }
        for (MessageQueue queue : queues) {
            queue.setTopic(this.withNamespace(queue.getTopic()));
        }
        return queues;
    }

    public void resetClientConfig(ClientConfig cc) {
        this.namesrvAddr = cc.namesrvAddr;
        this.clientIP = cc.clientIP;
        this.instanceName = cc.instanceName;
        this.clientCallbackExecutorThreads = cc.clientCallbackExecutorThreads;
        this.pollNameServerInterval = cc.pollNameServerInterval;
        this.updateConsumeQueueOffsetInterval = cc.updateConsumeQueueOffsetInterval;
        this.heartbeatBrokerInterval = cc.heartbeatBrokerInterval;
        this.persistConsumerOffsetInterval = cc.persistConsumerOffsetInterval;
        this.clientConfigInterval = cc.clientConfigInterval;
        this.unitMode = cc.unitMode;
        this.unitName = cc.unitName;
        this.vipChannelEnabled = cc.vipChannelEnabled;
        this.decodeReadBody = cc.decodeReadBody;
        this.decodeDecompressBody = cc.decodeDecompressBody;
        this.useTLS = cc.useTLS;
        this.sockProxyJson = cc.sockProxyJson;
        this.language = cc.language;
        this.namespace = cc.namespace;
        this.autoCleanTopicRouteNotFound = cc.autoCleanTopicRouteNotFound;
        this.recordApiStats = cc.recordApiStats;
        this.disableCallbackExecutor = cc.disableCallbackExecutor;
        this.disableNettyWorkerGroup = cc.disableNettyWorkerGroup;
        this.detectBrokerInterval = cc.detectBrokerInterval;
        this.detectInterval = cc.detectInterval;
        this.detectTimeout = cc.detectTimeout;
        this.pullTimeDelayMillsWhenException = cc.pullTimeDelayMillsWhenException;
        this.sendLatencyEnable = cc.sendLatencyEnable;
        this.startDetectorEnable = cc.startDetectorEnable;
    }

    public ClientConfig cloneClientConfig() {
        ClientConfig cc = new ClientConfig();
        cc.namesrvAddr = this.namesrvAddr;
        cc.clientIP = this.clientIP;
        cc.instanceName = this.instanceName;
        cc.clientCallbackExecutorThreads = this.clientCallbackExecutorThreads;
        cc.pollNameServerInterval = this.pollNameServerInterval;
        cc.updateConsumeQueueOffsetInterval = this.updateConsumeQueueOffsetInterval;
        cc.heartbeatBrokerInterval = this.heartbeatBrokerInterval;
        cc.persistConsumerOffsetInterval = this.persistConsumerOffsetInterval;
        cc.clientConfigInterval = this.clientConfigInterval;
        cc.unitMode = this.unitMode;
        cc.unitName = this.unitName;
        cc.vipChannelEnabled = this.vipChannelEnabled;
        cc.decodeReadBody = this.decodeReadBody;
        cc.decodeDecompressBody = this.decodeDecompressBody;
        cc.useTLS = this.useTLS;
        cc.sockProxyJson = this.sockProxyJson;
        cc.language = this.language;
        cc.namespace = this.namespace;
        cc.autoCleanTopicRouteNotFound = this.autoCleanTopicRouteNotFound;
        cc.recordApiStats = this.recordApiStats;
        cc.disableNettyWorkerGroup = this.disableNettyWorkerGroup;
        cc.disableCallbackExecutor = this.disableCallbackExecutor;
        cc.detectBrokerInterval = this.detectBrokerInterval;
        cc.detectInterval = this.detectInterval;
        cc.detectTimeout = this.detectTimeout;
        cc.pullTimeDelayMillsWhenException = this.pullTimeDelayMillsWhenException;
        cc.sendLatencyEnable = this.sendLatencyEnable;
        cc.startDetectorEnable = this.startDetectorEnable;
        return cc;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public int getClientCallbackExecutorThreads() {
        return this.clientCallbackExecutorThreads;
    }

    public void setClientCallbackExecutorThreads(int clientCallbackExecutorThreads) {
        this.clientCallbackExecutorThreads = clientCallbackExecutorThreads;
    }

    public int getPollNameServerInterval() {
        return this.pollNameServerInterval;
    }

    public int getClientConfigInterval() {
        return this.clientConfigInterval;
    }

    public int getDetectBrokerInterval() {
        return this.detectBrokerInterval;
    }

    public void setPollNameServerInterval(int pollNameServerInterval) {
        this.pollNameServerInterval = pollNameServerInterval;
    }

    public int getHeartbeatBrokerInterval() {
        return this.heartbeatBrokerInterval;
    }

    public long getPullTimeDelayMillsWhenException() {
        return this.pullTimeDelayMillsWhenException;
    }

    public void setPullTimeDelayMillsWhenException(long pullTimeDelayMillsWhenException) {
        this.pullTimeDelayMillsWhenException = pullTimeDelayMillsWhenException;
    }

    public void setHeartbeatBrokerInterval(int heartbeatBrokerInterval) {
        this.heartbeatBrokerInterval = heartbeatBrokerInterval;
    }

    public int getPersistConsumerOffsetInterval() {
        return this.persistConsumerOffsetInterval;
    }

    public void setPersistConsumerOffsetInterval(int persistConsumerOffsetInterval) {
        this.persistConsumerOffsetInterval = persistConsumerOffsetInterval;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public boolean isUnitMode() {
        return this.unitMode;
    }

    public void setUnitMode(boolean unitMode) {
        this.unitMode = unitMode;
    }

    public boolean isVipChannelEnabled() {
        return this.vipChannelEnabled;
    }

    public void setVipChannelEnabled(boolean vipChannelEnabled) {
        this.vipChannelEnabled = vipChannelEnabled;
    }

    public boolean isDecodeReadBody() {
        return this.decodeReadBody;
    }

    public void setDecodeReadBody(boolean decodeReadBody) {
        this.decodeReadBody = decodeReadBody;
    }

    public boolean isDecodeDecompressBody() {
        return this.decodeDecompressBody;
    }

    public void setDecodeDecompressBody(boolean decodeDecompressBody) {
        this.decodeDecompressBody = decodeDecompressBody;
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public boolean isUseTLS() {
        return this.useTLS;
    }

    public void setUseTLS(boolean useTLS) {
        this.useTLS = useTLS;
    }

    public String getSockProxyJson() {
        return this.sockProxyJson;
    }

    public void setSockProxyJson(String proxyJson) {
        this.sockProxyJson = proxyJson;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageCode language) {
        this.language = language;
    }

    public boolean isAutoCleanTopicRouteNotFound() {
        return this.autoCleanTopicRouteNotFound;
    }

    public void setAutoCleanTopicRouteNotFound(boolean autoCleanTopicRouteNotFound) {
        this.autoCleanTopicRouteNotFound = autoCleanTopicRouteNotFound;
    }

    public boolean isRecordApiStats() {
        return this.recordApiStats;
    }

    public void setRecordApiStats(boolean recordApiStats) {
        this.recordApiStats = recordApiStats;
    }

    public boolean isDisableCallbackExecutor() {
        return this.disableCallbackExecutor;
    }

    public void setDisableCallbackExecutor(boolean disableCallbackExecutor) {
        this.disableCallbackExecutor = disableCallbackExecutor;
    }

    public boolean isDisableNettyWorkerGroup() {
        return this.disableNettyWorkerGroup;
    }

    public void setDisableNettyWorkerGroup(boolean disableNettyWorkerGroup) {
        this.disableNettyWorkerGroup = disableNettyWorkerGroup;
    }

    public boolean isSendLatencyEnable() {
        return this.sendLatencyEnable;
    }

    public void setSendLatencyEnable(boolean sendLatencyEnable) {
        this.sendLatencyEnable = sendLatencyEnable;
    }

    public boolean isStartDetectorEnable() {
        return this.startDetectorEnable;
    }

    public void setStartDetectorEnable(boolean startDetectorEnable) {
        this.startDetectorEnable = startDetectorEnable;
    }

    public int getDetectTimeout() {
        return this.detectTimeout;
    }

    public int getDetectInterval() {
        return this.detectInterval;
    }

    public String toString() {
        return "ClientConfig{namesrvAddr='" + this.namesrvAddr + '\'' + ", clientIP='" + this.clientIP + '\'' + ", instanceName='" + this.instanceName + '\'' + ", namespace='" + this.namespace + '\'' + ", clientCallbackExecutorThreads=" + this.clientCallbackExecutorThreads + ", pollNameServerInterval=" + this.pollNameServerInterval + ", updateConsumeQueueOffsetInterval=" + this.updateConsumeQueueOffsetInterval + ", heartbeatBrokerInterval=" + this.heartbeatBrokerInterval + ", persistConsumerOffsetInterval=" + this.persistConsumerOffsetInterval + ", clientConfigInterval=" + this.clientConfigInterval + ", detectBrokerInterval=" + this.detectBrokerInterval + ", detectTimeout=" + this.detectTimeout + ", detectInterval=" + this.detectInterval + ", pullTimeDelayMillsWhenException=" + this.pullTimeDelayMillsWhenException + ", unitMode=" + this.unitMode + ", unitName='" + this.unitName + '\'' + ", vipChannelEnabled=" + this.vipChannelEnabled + ", decodeReadBody=" + this.decodeReadBody + ", decodeDecompressBody=" + this.decodeDecompressBody + ", autoCleanTopicRouteNotFound=" + this.autoCleanTopicRouteNotFound + ", recordApiStats=" + this.recordApiStats + ", disableCallbackExecutor=" + this.disableCallbackExecutor + ", disableNettyWorkerGroup=" + this.disableNettyWorkerGroup + ", sendLatencyEnable=" + this.sendLatencyEnable + ", startDetectorEnable=" + this.startDetectorEnable + ", useTLS=" + this.useTLS + ", sockProxyJson=" + this.sockProxyJson + ", language=" + (Object)((Object)this.language) + '}';
    }

    public int getUpdateConsumeQueueOffsetInterval() {
        return this.updateConsumeQueueOffsetInterval;
    }

    public void setUpdateConsumeQueueOffsetInterval(int updateConsumeQueueOffsetInterval) {
        this.updateConsumeQueueOffsetInterval = updateConsumeQueueOffsetInterval;
    }

    public boolean isFetchRemoteClientConfigEnable() {
        return this.fetchRemoteClientConfigEnable;
    }

    public void setFetchRemoteClientConfigEnable(boolean fetchRemoteClientConfigEnable) {
        this.fetchRemoteClientConfigEnable = fetchRemoteClientConfigEnable;
    }
}

