/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.sasl.client;

import com.aliyun.openservices.ons.sasl.client.ServiceAuthException;
import com.aliyun.openservices.ons.sasl.client.SigningAlgorithm;
import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class ServiceAuthSigner {
    public static final Charset defaultCharset = Charset.forName("UTF-8");
    public static final SigningAlgorithm defaultAlgorithm = SigningAlgorithm.HmacSHA1;
    private static final int CAL_SIGNATURE_FAILED = 10015;
    private static final String CAL_SIGNATURE_FAILED_MSG = "[%s:signature-failed] unable to calculate a request signature. error=%s";

    public static String calSignature(String data, String key) throws ServiceAuthException {
        return ServiceAuthSigner.calSignature(data, key, defaultAlgorithm, defaultCharset);
    }

    public static String calSignature(String data, String key, SigningAlgorithm algorithm, Charset charset) throws ServiceAuthException {
        return ServiceAuthSigner.signAndBase64Encode(data, key, algorithm, charset);
    }

    private static String signAndBase64Encode(String data, String key, SigningAlgorithm algorithm, Charset charset) throws ServiceAuthException {
        try {
            byte[] signature = ServiceAuthSigner.sign(data.getBytes(charset), key.getBytes(charset), algorithm);
            return new String(Base64.encodeBase64((byte[])signature), defaultCharset);
        }
        catch (Exception e) {
            String message = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, e.getMessage());
            throw new ServiceAuthException("CAL_SIGNATURE_FAILED", 10015, message, e);
        }
    }

    private static byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws ServiceAuthException {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            String message = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, e.getMessage());
            throw new ServiceAuthException("CAL_SIGNATURE_FAILED", 10015, message, e);
        }
    }

    public static String calSignature(byte[] data, String key) throws ServiceAuthException {
        return ServiceAuthSigner.calSignature(data, key, defaultAlgorithm, defaultCharset);
    }

    public static String calSignature(byte[] data, String key, SigningAlgorithm algorithm, Charset charset) throws ServiceAuthException {
        return ServiceAuthSigner.signAndBase64Encode(data, key, algorithm, charset);
    }

    private static String signAndBase64Encode(byte[] data, String key, SigningAlgorithm algorithm, Charset charset) throws ServiceAuthException {
        try {
            byte[] signature = ServiceAuthSigner.sign(data, key.getBytes(charset), algorithm);
            return new String(Base64.encodeBase64((byte[])signature), defaultCharset);
        }
        catch (Exception e) {
            String message = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, e.getMessage());
            throw new ServiceAuthException("CAL_SIGNATURE_FAILED", 10015, message, e);
        }
    }
}

