/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.ServiceException;
import com.aliyun.openservices.ots.comm.ResponseHandler;
import com.aliyun.openservices.ots.comm.ResponseMessage;
import com.aliyun.openservices.ots.internal.OTSCompressUtil;
import com.aliyun.openservices.ots.internal.OTSUtil;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.Inflater;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;

public class OTSDeflateResponseHandler
implements ResponseHandler {
    private static final String OTS_COMPRESS_TYPE = "deflate";

    @Override
    public void handle(ResponseMessage responseData) throws ServiceException, ClientException {
        Map<String, String> header = responseData.getHeadersMap();
        String compressType = header.get("x-ots-response-compress-type");
        if (compressType != null) {
            try {
                if (!OTS_COMPRESS_TYPE.equalsIgnoreCase(compressType.trim())) {
                    throw new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidResponseCompressType", compressType.trim()));
                }
                String strRawDataSize = header.get("x-ots-response-compress-size");
                if (strRawDataSize == null) {
                    throw new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("RequiredHeaderNotFound", "x-ots-response-compress-size"));
                }
                int rawDataSize = 0;
                try {
                    rawDataSize = Integer.valueOf(strRawDataSize);
                    if (rawDataSize <= 0) {
                        throw new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidResponseCompressSize", strRawDataSize));
                    }
                }
                catch (NumberFormatException e) {
                    throw new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("InvalidResponseCompressSize", strRawDataSize));
                }
                InputStream oldInput = responseData.getContent();
                Inflater decompresser = new Inflater();
                byte[] content = OTSCompressUtil.decompress(oldInput, rawDataSize, decompresser);
                responseData.getResponse().setEntity((HttpEntity)new ByteArrayEntity(content));
                oldInput.close();
            }
            catch (Exception e) {
                throw new ClientException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("ResponseDecompressFail", e.getMessage()));
            }
        }
    }
}

