/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.writer;

import com.aliyun.openservices.ots.internal.writer.WriterConfig;
import com.aliyun.openservices.ots.model.BatchWriteRowRequest;
import com.aliyun.openservices.ots.model.RowChange;
import com.aliyun.openservices.ots.model.RowPrimaryKey;
import java.util.HashSet;
import java.util.Set;

public class WriteRPCBuffer {
    public WriterConfig config;
    public Set<RowPrimaryKey> primaryKeySet;
    public BatchWriteRowRequest batchWriteRowRequest;
    public int totalSize;
    public int totalRowsCount;

    public WriteRPCBuffer(WriterConfig config) {
        this.config = config;
        this.primaryKeySet = new HashSet<RowPrimaryKey>();
        this.batchWriteRowRequest = new BatchWriteRowRequest();
        this.totalSize = 0;
        this.totalRowsCount = 0;
    }

    public boolean appendRowChange(RowChange rowChange) {
        RowPrimaryKey primaryKey = rowChange.getRowPrimaryKey();
        if (this.primaryKeySet.contains(primaryKey)) {
            return false;
        }
        if (this.totalSize + rowChange.getDataSize() > this.config.getMaxBatchSize()) {
            return false;
        }
        if (this.totalRowsCount >= this.config.getMaxBatchRowsCount()) {
            return false;
        }
        this.primaryKeySet.add(primaryKey);
        this.batchWriteRowRequest.addRowChange(rowChange);
        this.totalSize += rowChange.getDataSize();
        ++this.totalRowsCount;
        return true;
    }

    public BatchWriteRowRequest makeRequest() {
        return this.batchWriteRowRequest;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getTotalRowsCount() {
        return this.totalRowsCount;
    }

    public void clear() {
        this.primaryKeySet.clear();
        this.batchWriteRowRequest = new BatchWriteRowRequest();
        this.totalSize = 0;
        this.totalRowsCount = 0;
    }
}

