/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.lease;

import com.aliyun.openservices.ots.internal.streamclient.lease.Lease;
import com.aliyun.openservices.ots.internal.streamclient.model.ShardInfo;
import java.util.HashSet;
import java.util.Set;

public class ShardLease
extends Lease {
    private String streamId = "";
    private Set<String> parentShardIds = new HashSet<String>();
    private String checkpoint = "TRIM_HORIZON";

    public ShardLease(String leaseKey) {
        super(leaseKey);
    }

    public ShardLease(ShardLease shardLease) {
        super(shardLease);
        this.streamId = shardLease.getStreamId();
        this.checkpoint = shardLease.getCheckpoint();
        this.parentShardIds.addAll(shardLease.getParentShardIds());
    }

    @Override
    public <T extends Lease> void update(T other) {
        if (!(other instanceof ShardLease)) {
            throw new IllegalArgumentException();
        }
        super.update(other);
        this.setCheckpoint(((ShardLease)other).getCheckpoint());
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public Set<String> getParentShardIds() {
        return this.parentShardIds;
    }

    public void setParentShardIds(Set<String> parentShardIds) {
        this.parentShardIds = parentShardIds;
    }

    public String getCheckpoint() {
        return this.checkpoint;
    }

    public void setCheckpoint(String checkpoint) {
        this.checkpoint = checkpoint;
    }

    public ShardInfo toShardInfo() {
        return new ShardInfo(this.getLeaseKey(), this.getStreamId(), this.getParentShardIds(), this.getLeaseIdentifier());
    }

    @Override
    public <T extends Lease> T copy() {
        return (T)new ShardLease(this);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.streamId != null ? this.streamId.hashCode() : 0);
        result = 31 * result + (this.parentShardIds != null ? this.parentShardIds.hashCode() : 0);
        result = 31 * result + (this.checkpoint != null ? this.checkpoint.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShardLease)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ShardLease other = (ShardLease)obj;
        if (this.streamId == null ? other.streamId != null : !this.streamId.equals(other.streamId)) {
            return false;
        }
        if (this.checkpoint == null ? other.checkpoint != null : !this.checkpoint.equals(other.checkpoint)) {
            return false;
        }
        return !(this.parentShardIds == null ? other.parentShardIds != null : !this.parentShardIds.equals(other.parentShardIds));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ShardLease [leaseKey=");
        sb.append(this.getLeaseKey());
        sb.append(", leaseIdentifier=");
        sb.append(this.getLeaseIdentifier());
        sb.append(", leaseOwner=");
        sb.append(this.getLeaseOwner());
        sb.append(", leaseCounter=");
        sb.append("" + this.getLeaseCounter());
        sb.append(", lastCounterIncrementMillis=");
        sb.append("" + this.getLastCounterIncrementMillis());
        sb.append(", leaseStealer=");
        sb.append(this.getLeaseStealer());
        sb.append(", checkpoint=");
        sb.append(this.checkpoint);
        sb.append(", streamId=");
        sb.append(this.streamId);
        sb.append(", parentShardIds=");
        sb.append(this.parentShardIds);
        sb.append("]");
        return sb.toString();
    }
}

