/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.InternalClient;
import com.alicloud.openservices.tablestore.model.AbstractColumnIteratorImpl;
import com.alicloud.openservices.tablestore.model.CapacityUnit;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.Row;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GetRowColumnIteratorImpl
extends AbstractColumnIteratorImpl {
    private InternalClient internalClient;
    private GetRowRequest getRowRequest;
    private PrimaryKey primaryKey;
    private Iterator<Column> columnIterator;
    private byte[] token;
    private boolean complete = false;
    private CapacityUnit capacityUnit = new CapacityUnit(0, 0);

    public GetRowColumnIteratorImpl(InternalClient client, GetRowRequest getRowRequest) {
        this.internalClient = client;
        this.getRowRequest = getRowRequest;
    }

    public boolean isRowExistent() {
        while (!this.complete && this.primaryKey == null) {
            this.fetchData();
        }
        return this.primaryKey != null;
    }

    public void fetchData() {
        this.getRowRequest.getRowQueryCriteria().setToken(this.token);
        GetRowResponse getRowResponse = null;
        try {
            getRowResponse = this.internalClient.getRowInternal(this.getRowRequest, null).get();
        }
        catch (Exception ex) {
            throw new ClientException(ex);
        }
        this.capacityUnit.setReadCapacityUnit(this.capacityUnit.getReadCapacityUnit() + getRowResponse.getConsumedCapacity().getCapacityUnit().getReadCapacityUnit());
        this.capacityUnit.setWriteCapacityUnit(this.capacityUnit.getWriteCapacityUnit() + getRowResponse.getConsumedCapacity().getCapacityUnit().getWriteCapacityUnit());
        Row row = getRowResponse.getRow();
        if (row != null) {
            if (this.primaryKey == null) {
                this.primaryKey = row.getPrimaryKey();
            }
            this.columnIterator = Arrays.asList(row.getColumns()).iterator();
        }
        if (getRowResponse.hasNextToken()) {
            this.token = getRowResponse.getNextToken();
        } else {
            this.complete = true;
        }
    }

    @Override
    public boolean hasNext() {
        while (!(this.complete || this.columnIterator != null && this.columnIterator.hasNext())) {
            this.fetchData();
        }
        return this.columnIterator != null && this.columnIterator.hasNext();
    }

    @Override
    public Column next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.columnIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

