/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.filter;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.protocol.OTSProtocolBuilder;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.condition.SingleColumnValueCondition;
import com.alicloud.openservices.tablestore.model.filter.ColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.FilterType;
import com.aliyun.ots.thirdparty.com.google.protobuf.ByteString;

public class SingleColumnValueFilter
extends ColumnValueFilter {
    private CompareOperator operator;
    private String columnName;
    private ColumnValue columnValue;
    private boolean passIfMissing = true;
    private boolean latestVersionsOnly = true;

    public SingleColumnValueFilter(String columnName, CompareOperator operator, ColumnValue columnValue) {
        this.setColumnName(columnName);
        this.setOperator(operator);
        this.setColumnValue(columnValue);
    }

    public CompareOperator getOperator() {
        return this.operator;
    }

    public SingleColumnValueFilter setOperator(CompareOperator operator) {
        Preconditions.checkNotNull(operator, "The operator should not be null.");
        this.operator = operator;
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public SingleColumnValueFilter setColumnName(String columnName) {
        Preconditions.checkArgument(columnName != null && !columnName.isEmpty(), "The name of column should not be null or empty.");
        this.columnName = columnName;
        return this;
    }

    public ColumnValue getColumnValue() {
        return this.columnValue;
    }

    public SingleColumnValueFilter setColumnValue(ColumnValue columnValue) {
        Preconditions.checkNotNull(columnValue, "The value of column should not be null.");
        this.columnValue = columnValue;
        return this;
    }

    public boolean isPassIfMissing() {
        return this.passIfMissing;
    }

    public SingleColumnValueFilter setPassIfMissing(boolean passIfMissing) {
        this.passIfMissing = passIfMissing;
        return this;
    }

    public boolean isLatestVersionsOnly() {
        return this.latestVersionsOnly;
    }

    public SingleColumnValueFilter setLatestVersionsOnly(boolean latestVersionsOnly) {
        this.latestVersionsOnly = latestVersionsOnly;
        return this;
    }

    public SingleColumnValueCondition toCondition() {
        SingleColumnValueCondition.CompareOperator filterOperator;
        switch (this.operator) {
            case EQUAL: {
                filterOperator = SingleColumnValueCondition.CompareOperator.EQUAL;
                break;
            }
            case NOT_EQUAL: {
                filterOperator = SingleColumnValueCondition.CompareOperator.NOT_EQUAL;
                break;
            }
            case GREATER_THAN: {
                filterOperator = SingleColumnValueCondition.CompareOperator.GREATER_THAN;
                break;
            }
            case GREATER_EQUAL: {
                filterOperator = SingleColumnValueCondition.CompareOperator.GREATER_EQUAL;
                break;
            }
            case LESS_THAN: {
                filterOperator = SingleColumnValueCondition.CompareOperator.LESS_THAN;
                break;
            }
            case LESS_EQUAL: {
                filterOperator = SingleColumnValueCondition.CompareOperator.LESS_EQUAL;
                break;
            }
            default: {
                throw new ClientException("Unknown operator: " + this.operator.name());
            }
        }
        SingleColumnValueCondition singleColumnValueCondition = new SingleColumnValueCondition(this.columnName, filterOperator, this.columnValue);
        singleColumnValueCondition.setLatestVersionsOnly(this.latestVersionsOnly);
        singleColumnValueCondition.setPassIfMissing(this.passIfMissing);
        return singleColumnValueCondition;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.SINGLE_COLUMN_VALUE_FILTER;
    }

    @Override
    public ByteString serialize() {
        return OTSProtocolBuilder.buildSingleColumnValueFilter(this);
    }

    public static enum CompareOperator {
        EQUAL,
        NOT_EQUAL,
        GREATER_THAN,
        GREATER_EQUAL,
        LESS_THAN,
        LESS_EQUAL;

    }
}

