/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.InternalClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.TunnelClientInterface;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.tunnel.CreateTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.CreateTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.DeleteTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.DeleteTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.DescribeTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.DescribeTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.ListTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.ListTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.CheckpointRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.CheckpointResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ConnectTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ConnectTunnelResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.GetCheckpointRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.GetCheckpointResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.HeartbeatRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.HeartbeatResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ReadRecordsRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ReadRecordsResponse;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ShutdownTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.ShutdownTunnelResponse;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class TunnelClient
implements TunnelClientInterface {
    private InternalClient internalClient;

    public TunnelClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName) {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setEnableResponseValidation(false);
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName, conf);
    }

    public TunnelClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, String stsToken) {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setEnableResponseValidation(false);
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName, conf, null, stsToken);
    }

    public TunnelClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, null);
    }

    public TunnelClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, String stsToken) {
        this(endpoint, accessKeyId, accessKeySecret, instanceName, config, stsToken, null);
    }

    public TunnelClient(String endpoint, String accessKeyId, String accessKeySecret, String instanceName, ClientConfiguration config, String stsToken, ExecutorService callbackExecutor) {
        if (config != null) {
            config.setEnableResponseValidation(false);
        } else {
            config = new ClientConfiguration();
            config.setEnableResponseValidation(false);
        }
        this.internalClient = new InternalClient(endpoint, accessKeyId, accessKeySecret, instanceName, config, callbackExecutor, stsToken);
    }

    TunnelClient(InternalClient internalClient) {
        this.internalClient = internalClient;
    }

    public void setExtraHeaders(Map<String, String> extraHeaders) {
        this.internalClient.setExtraHeaders(extraHeaders);
    }

    public String getEndpoint() {
        return this.internalClient.getEndpoint();
    }

    public String getInstanceName() {
        return this.internalClient.getInstanceName();
    }

    @Override
    public CreateTunnelResponse createTunnel(CreateTunnelRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<CreateTunnelResponse> resp = this.internalClient.createTunnel(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public ListTunnelResponse listTunnel(ListTunnelRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<ListTunnelResponse> resp = this.internalClient.listTunnel(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public DescribeTunnelResponse describeTunnel(DescribeTunnelRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<DescribeTunnelResponse> resp = this.internalClient.describeTunnel(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public DeleteTunnelResponse deleteTunnel(DeleteTunnelRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<DeleteTunnelResponse> resp = this.internalClient.deleteTunnel(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public ConnectTunnelResponse connectTunnel(ConnectTunnelRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<ConnectTunnelResponse> resp = this.internalClient.connectTunnel(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public HeartbeatResponse heartbeat(HeartbeatRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<HeartbeatResponse> resp = this.internalClient.heartbeat(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public ShutdownTunnelResponse shutdownTunnel(ShutdownTunnelRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<ShutdownTunnelResponse> resp = this.internalClient.shutdownTunnel(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public GetCheckpointResponse getCheckpoint(GetCheckpointRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<GetCheckpointResponse> resp = this.internalClient.getCheckpoint(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public ReadRecordsResponse readRecords(ReadRecordsRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<ReadRecordsResponse> resp = this.internalClient.readRecords(request, null);
        return this.waitForFuture(resp);
    }

    @Override
    public CheckpointResponse checkpoint(CheckpointRequest request) throws TableStoreException, ClientException {
        Preconditions.checkNotNull(request);
        Future<CheckpointResponse> resp = this.internalClient.checkpoint(request, null);
        return this.waitForFuture(resp);
    }

    private <Res> Res waitForFuture(Future<Res> f) {
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            throw new ClientException(String.format("The thread was interrupted: %s", e.getMessage()));
        }
        catch (ExecutionException e) {
            throw new ClientException("The thread was aborted", e);
        }
    }

    @Override
    public void shutdown() {
        this.internalClient.shutdown();
    }
}

