/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;

public class PartitionRange {
    private PrimaryKeyValue begin;
    private PrimaryKeyValue end;

    public PartitionRange(PrimaryKeyValue begin, PrimaryKeyValue end) {
        Preconditions.checkNotNull(begin, "The begin key of partition range should not be null.");
        Preconditions.checkNotNull(end, "The end key of partition range should not be null.");
        Preconditions.checkArgument(!begin.isInfMax() && !begin.isInfMin(), "The value of begin can't be INF_MIN or INF_MAX.");
        Preconditions.checkArgument(!end.isInfMax() && !end.isInfMin(), "The value of end can't be INF_MIN or INF_MAX.");
        if (!begin.getType().equals((Object)end.getType())) {
            throw new IllegalArgumentException("The value type of begin and end must be the same.");
        }
        this.begin = begin;
        this.end = end;
    }

    public PrimaryKeyValue getBegin() {
        return this.begin;
    }

    public PrimaryKeyValue getEnd() {
        return this.end;
    }
}

