/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.timestream.internal.MetaCacheManager;
import com.alicloud.openservices.tablestore.timestream.internal.Utils;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamIdentifier;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamMeta;
import com.alicloud.openservices.tablestore.timestream.model.filter.Filter;
import com.alicloud.openservices.tablestore.timestream.model.query.MetaFilter;
import com.alicloud.openservices.tablestore.timestream.model.query.MetaGetter;
import java.util.concurrent.Future;

public class TimestreamMetaTable {
    private AsyncClient asyncClient;
    private String metaTableName;
    private String index;
    private MetaCacheManager metaCacheManager;

    protected TimestreamMetaTable(AsyncClient asyncClient, String metaTableName, String index, MetaCacheManager metaCacheManager) {
        this.asyncClient = asyncClient;
        this.metaTableName = metaTableName;
        this.index = index;
        this.metaCacheManager = metaCacheManager;
    }

    public void delete(TimestreamIdentifier identifier) {
        RowDeleteChange rowChange = Utils.serializeTimestreamMeta(this.metaTableName, identifier);
        DeleteRowRequest request = new DeleteRowRequest();
        request.setRowChange(rowChange);
        Future<DeleteRowResponse> future = this.asyncClient.deleteRow(request, null);
        Utils.waitForFuture(future);
    }

    public void put(TimestreamMeta meta) {
        if (this.metaCacheManager != null) {
            this.metaCacheManager.updateTimestreamMeta(meta.getIdentifier(), meta.getUpdateTimeInUsec());
        }
        RowPutChange rowChange = Utils.serializeTimestreamMeta(this.metaTableName, meta);
        PutRowRequest request = new PutRowRequest();
        request.setRowChange(rowChange);
        Future<PutRowResponse> future = this.asyncClient.putRow(request, null);
        Utils.waitForFuture(future);
    }

    public MetaGetter get(TimestreamIdentifier identifier) {
        return new MetaGetter(this.asyncClient, this.metaTableName, identifier);
    }

    public MetaFilter filter() {
        return new MetaFilter(this.asyncClient, this.metaTableName, this.index, null);
    }

    public MetaFilter filter(Filter filter) {
        return new MetaFilter(this.asyncClient, this.metaTableName, this.index, filter);
    }
}

