/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.TxnRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchWriteRowRequest
extends TxnRequest {
    private Map<String, List<RowChange>> rowChangesGroupByTable = new HashMap<String, List<RowChange>>();

    @Override
    public String getOperationName() {
        return "BatchWriteRow";
    }

    public void addRowChange(RowChange rowChange) {
        Preconditions.checkNotNull(rowChange, "The rowPutChange should not be null.");
        String tableName = rowChange.getTableName();
        List<RowChange> rowChanges = this.rowChangesGroupByTable.get(tableName);
        if (rowChanges == null) {
            rowChanges = new ArrayList<RowChange>();
            this.rowChangesGroupByTable.put(tableName, rowChanges);
        }
        rowChanges.add(rowChange);
    }

    public RowChange getRowChange(String tableName, int index) {
        List<RowChange> rowChanges = this.rowChangesGroupByTable.get(tableName);
        if (rowChanges == null) {
            return null;
        }
        if (index >= rowChanges.size()) {
            return null;
        }
        return rowChanges.get(index);
    }

    public Map<String, List<RowChange>> getRowChange() {
        return this.rowChangesGroupByTable;
    }

    public BatchWriteRowRequest createRequestForRetry(List<BatchWriteRowResponse.RowResult> failedRows) {
        Preconditions.checkArgument(failedRows != null && !failedRows.isEmpty(), "failedRows can't be null or empty.");
        BatchWriteRowRequest request = new BatchWriteRowRequest();
        for (BatchWriteRowResponse.RowResult rowResult : failedRows) {
            RowChange rowChange = this.getRowChange(rowResult.getTableName(), rowResult.getIndex());
            if (rowChange == null) {
                throw new IllegalArgumentException("Can not find item in table '" + rowResult.getTableName() + "' " + "with index " + rowResult.getIndex());
            }
            request.addRowChange(rowChange);
        }
        return request;
    }

    public boolean isEmpty() {
        return this.rowChangesGroupByTable.isEmpty();
    }

    public int getRowsCount() {
        int rowsCount = 0;
        for (Map.Entry<String, List<RowChange>> entry : this.rowChangesGroupByTable.entrySet()) {
            rowsCount += entry.getValue().size();
        }
        return rowsCount;
    }
}

