/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.PartialResultFailedException;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.http.AsyncServiceClient;
import com.alicloud.openservices.tablestore.core.http.BatchGetRowResponseConsumer;
import com.alicloud.openservices.tablestore.core.http.OTSUri;
import com.alicloud.openservices.tablestore.core.protocol.OTSProtocolBuilder;
import com.alicloud.openservices.tablestore.core.protocol.OtsInternalApi;
import com.alicloud.openservices.tablestore.core.protocol.ResultParserFactory;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.google.protobuf.Message;
import org.apache.http.concurrent.FutureCallback;

public class BatchGetRowLauncher
extends OperationLauncher<BatchGetRowRequest, BatchGetRowResponse> {
    private OTSUri uri;
    private TraceLogger tracer;
    private RetryStrategy retry;

    public BatchGetRowLauncher(OTSUri uri, TraceLogger tracer, RetryStrategy retry, String instanceName, AsyncServiceClient client, ServiceCredentials credentials, ClientConfiguration config, BatchGetRowRequest originRequest) {
        super(instanceName, client, credentials, config, originRequest);
        Preconditions.checkNotNull(uri);
        Preconditions.checkNotNull(tracer);
        Preconditions.checkNotNull(retry);
        this.uri = uri;
        this.tracer = tracer;
        this.retry = retry;
    }

    @Override
    public BatchGetRowRequest getRequestForRetry(Exception e) {
        BatchGetRowRequest request = (BatchGetRowRequest)this.originRequest;
        if (e instanceof PartialResultFailedException) {
            this.lastResult = (BatchGetRowResponse)((PartialResultFailedException)e).getResult();
            request = ((BatchGetRowRequest)this.originRequest).createRequestForRetry(((BatchGetRowResponse)this.lastResult).getFailedRows());
        }
        return request;
    }

    @Override
    public void fire(BatchGetRowRequest req, FutureCallback<BatchGetRowResponse> cb) {
        LogUtil.logBeforeExecution(this.tracer, this.retry);
        OtsInternalApi.BatchGetRowResponse defaultResponse = OtsInternalApi.BatchGetRowResponse.getDefaultInstance();
        this.asyncInvokePost(this.uri, null, (Message)OTSProtocolBuilder.buildBatchGetRowRequest(req.getCriteriasByTable()), this.tracer, new BatchGetRowResponseConsumer(ResultParserFactory.createFactory().createProtocolBufferResultParser((Message)defaultResponse, this.tracer.getTraceId()), this.tracer, this.retry, (BatchGetRowResponse)this.lastResult), cb);
    }
}

