/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.PartialResultFailedException;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.http.AsyncServiceClient;
import com.alicloud.openservices.tablestore.core.http.BatchWriteRowResponseConsumer;
import com.alicloud.openservices.tablestore.core.http.OTSUri;
import com.alicloud.openservices.tablestore.core.protocol.OTSProtocolBuilder;
import com.alicloud.openservices.tablestore.core.protocol.OtsInternalApi;
import com.alicloud.openservices.tablestore.core.protocol.ResultParserFactory;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.google.protobuf.Message;
import org.apache.http.concurrent.FutureCallback;

public class BatchWriteRowLauncher
extends OperationLauncher<BatchWriteRowRequest, BatchWriteRowResponse> {
    private OTSUri uri;
    private TraceLogger tracer;
    private RetryStrategy retry;

    public BatchWriteRowLauncher(OTSUri uri, TraceLogger tracer, RetryStrategy retry, String instanceName, AsyncServiceClient client, ServiceCredentials credentials, ClientConfiguration config, BatchWriteRowRequest originRequest) {
        super(instanceName, client, credentials, config, originRequest);
        Preconditions.checkNotNull(uri);
        Preconditions.checkNotNull(tracer);
        Preconditions.checkNotNull(retry);
        this.uri = uri;
        this.tracer = tracer;
        this.retry = retry;
    }

    @Override
    public BatchWriteRowRequest getRequestForRetry(Exception e) {
        BatchWriteRowRequest request = (BatchWriteRowRequest)this.originRequest;
        if (e instanceof PartialResultFailedException) {
            this.lastResult = (BatchWriteRowResponse)((PartialResultFailedException)e).getResult();
            request = ((BatchWriteRowRequest)this.originRequest).createRequestForRetry(((BatchWriteRowResponse)this.lastResult).getFailedRows());
        }
        return request;
    }

    @Override
    public void fire(BatchWriteRowRequest req, FutureCallback<BatchWriteRowResponse> cb) {
        LogUtil.logBeforeExecution(this.tracer, this.retry);
        OtsInternalApi.BatchWriteRowResponse defaultResponse = OtsInternalApi.BatchWriteRowResponse.getDefaultInstance();
        this.asyncInvokePost(this.uri, null, (Message)OTSProtocolBuilder.buildBatchWriteRowRequest(req), this.tracer, new BatchWriteRowResponseConsumer(ResultParserFactory.createFactory().createProtocolBufferResultParser((Message)defaultResponse, this.tracer.getTraceId()), this.tracer, this.retry, (BatchWriteRowResponse)this.lastResult), cb);
    }
}

