/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Pair;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RowChange;
import java.util.ArrayList;
import java.util.List;

public class RowUpdateChange
extends RowChange {
    private List<Pair<Column, Type>> columnsToUpdate = new ArrayList<Pair<Column, Type>>();
    private OptionalValue<Long> timestamp = new OptionalValue("Timestamp");

    public RowUpdateChange(String tableName) {
        super(tableName);
    }

    public RowUpdateChange(String tableName, PrimaryKey primaryKey) {
        super(tableName, primaryKey);
    }

    public RowUpdateChange(String tableName, PrimaryKey primaryKey, long ts) {
        super(tableName, primaryKey);
        this.timestamp.setValue(ts);
    }

    public RowUpdateChange(RowUpdateChange toCopy) {
        super(toCopy.getTableName(), toCopy.getPrimaryKey());
        if (toCopy.timestamp.isValueSet()) {
            this.timestamp.setValue(toCopy.timestamp.getValue());
        }
        this.columnsToUpdate.addAll(toCopy.columnsToUpdate);
    }

    public RowUpdateChange put(Column column) {
        this.columnsToUpdate.add(new Pair<Column, Type>(column, Type.PUT));
        return this;
    }

    public RowUpdateChange put(String name, ColumnValue value) {
        Column column = null;
        column = this.timestamp.isValueSet() ? new Column(name, value, this.timestamp.getValue()) : new Column(name, value);
        this.columnsToUpdate.add(new Pair<Column, Type>(column, Type.PUT));
        return this;
    }

    public RowUpdateChange put(String name, ColumnValue value, long ts) {
        this.columnsToUpdate.add(new Pair<Column, Type>(new Column(name, value, ts), Type.PUT));
        return this;
    }

    public RowUpdateChange put(List<Column> columns) {
        for (Column col : columns) {
            this.put(col);
        }
        return this;
    }

    public RowUpdateChange deleteColumn(String name, long ts) {
        this.columnsToUpdate.add(new Pair<Column, Type>(new Column(name, ColumnValue.INTERNAL_NULL_VALUE, ts), Type.DELETE));
        return this;
    }

    public RowUpdateChange deleteColumns(String name) {
        this.columnsToUpdate.add(new Pair<Column, Type>(new Column(name, ColumnValue.INTERNAL_NULL_VALUE), Type.DELETE_ALL));
        return this;
    }

    public List<Pair<Column, Type>> getColumnsToUpdate() {
        return this.columnsToUpdate;
    }

    @Override
    public int getDataSize() {
        int valueTotalSize = 0;
        for (Pair<Column, Type> col : this.columnsToUpdate) {
            valueTotalSize += col.getFirst().getDataSize();
        }
        return this.getPrimaryKey().getDataSize() + valueTotalSize;
    }

    public static enum Type {
        PUT,
        DELETE,
        DELETE_ALL;

    }
}

