/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.internal;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.TableOptions;
import com.alicloud.openservices.tablestore.model.internal.BloomFilterType;

public class TableOptionsEx
extends TableOptions {
    private OptionalValue<BloomFilterType> bloomFilterType = new OptionalValue("BloomFilterType");
    private OptionalValue<Integer> blockSize = new OptionalValue("BlockSize");

    public TableOptionsEx() {
    }

    public TableOptionsEx(int timeToLive) {
        this.setTimeToLive(timeToLive);
    }

    public TableOptionsEx(int timeToLive, int maxVersions) {
        this.setTimeToLive(timeToLive);
        this.setMaxVersions(maxVersions);
    }

    public TableOptionsEx(int timeToLive, int maxVersions, BloomFilterType bloomFilterType) {
        this.setTimeToLive(timeToLive);
        this.setMaxVersions(maxVersions);
        this.setBloomFilterType(bloomFilterType);
    }

    public TableOptionsEx(int timeToLive, int maxVersions, BloomFilterType bloomFilterType, int blockSize) {
        this.setTimeToLive(timeToLive);
        this.setMaxVersions(maxVersions);
        this.setBloomFilterType(bloomFilterType);
        this.setBlockSize(blockSize);
    }

    public BloomFilterType getBloomFilterType() {
        if (!this.bloomFilterType.isValueSet()) {
            throw new IllegalStateException("The value of BloomFilterType is not set.");
        }
        return this.bloomFilterType.getValue();
    }

    public void setBloomFilterType(BloomFilterType bloomFilterType) {
        this.bloomFilterType.setValue(bloomFilterType);
    }

    public boolean hasSetBloomFilterType() {
        return this.bloomFilterType.isValueSet();
    }

    public int getBlockSize() {
        if (!this.blockSize.isValueSet()) {
            throw new IllegalStateException("The value of BlockSize is not set.");
        }
        return this.blockSize.getValue();
    }

    public void setBlockSize(int blockSize) {
        Preconditions.checkArgument(blockSize > 0, "BlockSize must be greater than 0.");
        this.blockSize.setValue(blockSize);
    }

    public boolean hasSetBlockSize() {
        return this.blockSize.isValueSet();
    }

    @Override
    public String toString() {
        return super.toString() + ", " + this.bloomFilterType + ", " + this.blockSize;
    }

    @Override
    protected boolean jsonizeFields(StringBuilder sb, boolean firstItem) {
        firstItem = super.jsonizeFields(sb, firstItem);
        if (this.bloomFilterType.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"BloomFilterType\": \"");
            sb.append((Object)this.bloomFilterType.getValue());
            sb.append("\"");
        }
        if (this.blockSize.isValueSet()) {
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append("\"BlockSize\": ");
            sb.append(this.blockSize.getValue());
        }
        return firstItem;
    }
}

