/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.PartialResultFailedException;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProvider;
import com.alicloud.openservices.tablestore.core.http.AsyncServiceClient;
import com.alicloud.openservices.tablestore.core.http.BulkImportResponseConsumer;
import com.alicloud.openservices.tablestore.core.http.OTSUri;
import com.alicloud.openservices.tablestore.core.protocol.OTSProtocolBuilder;
import com.alicloud.openservices.tablestore.core.protocol.OtsInternalApi;
import com.alicloud.openservices.tablestore.core.protocol.ResultParserFactory;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.BulkImportRequest;
import com.alicloud.openservices.tablestore.model.BulkImportResponse;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.aliyun.ots.thirdparty.com.google.protobuf.Message;
import com.aliyun.ots.thirdparty.org.apache.http.concurrent.FutureCallback;

public class BulkImportLauncher
extends OperationLauncher<BulkImportRequest, BulkImportResponse> {
    private OTSUri uri;
    private TraceLogger tracer;
    private RetryStrategy retry;

    public BulkImportLauncher(OTSUri uri, TraceLogger tracer, RetryStrategy retry, String instanceName, AsyncServiceClient client, CredentialsProvider crdsProvider, ClientConfiguration config, BulkImportRequest originRequest) {
        super(instanceName, client, crdsProvider, config, originRequest);
        Preconditions.checkNotNull(uri);
        Preconditions.checkNotNull(tracer);
        Preconditions.checkNotNull(retry);
        this.uri = uri;
        this.tracer = tracer;
        this.retry = retry;
    }

    @Override
    public BulkImportRequest getRequestForRetry(Exception e) {
        BulkImportRequest request = (BulkImportRequest)this.originRequest;
        if (e instanceof PartialResultFailedException) {
            this.lastResult = (BulkImportResponse)((PartialResultFailedException)e).getResult();
            request = ((BulkImportRequest)this.originRequest).createRequestForRetry(((BulkImportResponse)this.lastResult).getFailedRows());
        }
        return request;
    }

    @Override
    public void fire(BulkImportRequest req, FutureCallback<BulkImportResponse> cb) {
        LogUtil.logBeforeExecution(this.tracer, this.retry);
        OtsInternalApi.BulkImportResponse defaultResponse = OtsInternalApi.BulkImportResponse.getDefaultInstance();
        this.asyncInvokePost(this.uri, null, (Message)OTSProtocolBuilder.buildBulkImportRequest(req), this.tracer, new BulkImportResponseConsumer(ResultParserFactory.createFactory().createProtocolBufferResultParser((Message)defaultResponse, this.tracer.getTraceId()), this.tracer, this.retry, (BulkImportResponse)this.lastResult), cb);
    }
}

