/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCell;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferConsts;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferExtension;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferInputStream;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferRow;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferSequenceInfo;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainBufferCodedInputStream {
    private static Logger logger = LoggerFactory.getLogger(PlainBufferCodedInputStream.class);
    private PlainBufferInputStream input = null;

    public PlainBufferCodedInputStream(PlainBufferInputStream input) {
        Preconditions.checkNotNull(input, "The plainBufferInputStream should not be null.");
        this.input = input;
    }

    public int readTag() throws IOException {
        return this.input.readTag();
    }

    public boolean checkLastTagWas(int tag) {
        return this.input.checkLastTagWas(tag);
    }

    public int getLastTag() {
        return this.input.getLastTag();
    }

    public int readHeader() throws IOException {
        return this.input.readUInt32();
    }

    public ColumnValue readCellValue() throws IOException {
        if (!this.checkLastTagWas(5)) {
            throw new IOException("Expect TAG_CELL_VALUE but it was " + PlainBufferConsts.printTag(this.getLastTag()));
        }
        int length = this.input.readRawLittleEndian32();
        byte type = this.input.readRawByte();
        ColumnValue columnValue = null;
        switch (type) {
            case 0: {
                columnValue = ColumnValue.fromLong(this.input.readInt64());
                break;
            }
            case 7: {
                columnValue = ColumnValue.fromBinary(this.input.readBytes(this.input.readUInt32()));
                break;
            }
            case 3: {
                byte[] originBytes = this.input.readBytes(this.input.readUInt32());
                columnValue = ColumnValue.fromString(PlainBufferInputStream.bytes2UTFString(originBytes), originBytes);
                break;
            }
            case 2: {
                columnValue = ColumnValue.fromBoolean(this.input.readBoolean());
                break;
            }
            case 1: {
                columnValue = ColumnValue.fromDouble(this.input.readDouble());
                break;
            }
            default: {
                throw new IOException("Unsupported column type: " + type);
            }
        }
        this.readTag();
        return columnValue;
    }

    public PrimaryKeyValue readCellPrimaryKeyValue() throws IOException {
        if (!this.checkLastTagWas(5)) {
            throw new IOException("Expect TAG_CELL_VALUE but it was " + PlainBufferConsts.printTag(this.getLastTag()));
        }
        int length = this.input.readRawLittleEndian32();
        byte type = this.input.readRawByte();
        PrimaryKeyValue primaryKeyValue = null;
        switch (type) {
            case 0: {
                primaryKeyValue = PrimaryKeyValue.fromLong(this.input.readInt64());
                break;
            }
            case 7: {
                primaryKeyValue = PrimaryKeyValue.fromBinary(this.input.readBytes(this.input.readUInt32()));
                break;
            }
            case 3: {
                byte[] originBytes = this.input.readBytes(this.input.readUInt32());
                primaryKeyValue = PrimaryKeyValue.fromString(PlainBufferInputStream.bytes2UTFString(originBytes), originBytes);
                break;
            }
            case 10: {
                primaryKeyValue = PrimaryKeyValue.INF_MAX;
                break;
            }
            case 9: {
                primaryKeyValue = PrimaryKeyValue.INF_MIN;
                break;
            }
            default: {
                throw new IOException("Unsupported pk type: " + type);
            }
        }
        this.readTag();
        return primaryKeyValue;
    }

    public void skipRawSize(int length) throws IOException {
        this.input.readBytes(length);
    }

    public PlainBufferCell readCell(boolean isPK) throws IOException {
        if (!this.checkLastTagWas(3)) {
            throw new IOException("Expect TAG_CELL but it was " + PlainBufferConsts.printTag(this.getLastTag()));
        }
        PlainBufferCell cell = new PlainBufferCell();
        this.readTag();
        if (this.getLastTag() == 4) {
            cell.setCellName(this.input.readUTFString(this.input.readRawLittleEndian32()));
            this.readTag();
        }
        if (this.getLastTag() == 5) {
            if (isPK) {
                cell.setPkCellValue(this.readCellPrimaryKeyValue());
            } else {
                cell.setCellValue(this.readCellValue());
            }
        }
        if (this.getLastTag() == 6) {
            cell.setCellType(this.input.readRawByte());
            this.readTag();
        }
        if (this.getLastTag() == 7) {
            long timestamp = this.input.readInt64();
            if (timestamp < 0L) {
                throw new IOException("The timestamp is negative.");
            }
            cell.setCellTimestamp(timestamp);
            this.readTag();
        }
        if (this.getLastTag() == 10) {
            byte checksum = this.input.readRawByte();
            this.readTag();
            if (cell.getChecksum() != checksum) {
                logger.error("Checksum mismatch. Cell: " + cell.toString() + ". Checksum: " + checksum + ". PlainBuffer: " + this.input.toString());
                throw new IOException("Checksum is mismatch.");
            }
        } else {
            throw new IOException("Expect TAG_CELL_CHECKSUM but it was " + PlainBufferConsts.printTag(this.getLastTag()));
        }
        return cell;
    }

    public List<PlainBufferCell> readRowPK() throws IOException {
        if (!this.checkLastTagWas(1)) {
            throw new IOException("Expect TAG_ROW_PK but it was " + PlainBufferConsts.printTag(this.getLastTag()));
        }
        ArrayList<PlainBufferCell> primaryKeyColumns = new ArrayList<PlainBufferCell>();
        this.readTag();
        while (this.checkLastTagWas(3)) {
            PlainBufferCell cell = this.readCell(true);
            primaryKeyColumns.add(cell);
        }
        return primaryKeyColumns;
    }

    public List<PlainBufferCell> readRowData() throws IOException {
        if (!this.checkLastTagWas(2)) {
            throw new IOException("Expect TAG_ROW_DATA but it was " + PlainBufferConsts.printTag(this.getLastTag()));
        }
        ArrayList<PlainBufferCell> columns = new ArrayList<PlainBufferCell>();
        this.readTag();
        while (this.checkLastTagWas(3)) {
            columns.add(this.readCell(false));
        }
        return columns;
    }

    public PlainBufferExtension readExtension() throws IOException {
        PlainBufferExtension extension = new PlainBufferExtension();
        if (this.checkLastTagWas(11)) {
            this.input.readUInt32();
            this.readTag();
            while (PlainBufferConsts.isTagInExtension(this.getLastTag())) {
                if (this.checkLastTagWas(12)) {
                    extension.setSequenceInfo(this.readSequenceInfo());
                    continue;
                }
                int length = this.input.readRawLittleEndian32();
                this.skipRawSize(length);
                this.readTag();
            }
        }
        return extension;
    }

    public PlainBufferRow readRow() throws IOException {
        return this.readRow(true);
    }

    public PlainBufferRow readRow(Boolean shouldContainsPk) throws IOException {
        ArrayList<PlainBufferCell> columns = new ArrayList();
        List<Object> primaryKey = new ArrayList();
        boolean hasDeleteMarker = false;
        if (this.checkLastTagWas(1)) {
            primaryKey = this.readRowPK();
            if (shouldContainsPk.booleanValue() && primaryKey.isEmpty()) {
                throw new IOException("The primary key of row is empty.");
            }
        }
        if (this.checkLastTagWas(2)) {
            columns = this.readRowData();
        }
        if (this.checkLastTagWas(8)) {
            hasDeleteMarker = true;
            this.readTag();
        }
        PlainBufferRow row = new PlainBufferRow(primaryKey, columns, hasDeleteMarker);
        row.setExtension(this.readExtension());
        if (this.checkLastTagWas(9)) {
            byte checksum = this.input.readRawByte();
            this.readTag();
            if (row.getChecksum() != checksum) {
                logger.error("Checksum mismatch. Row: " + row.toString() + ". Checksum: " + checksum + ". PlainBuffer: " + this.input.toString());
                throw new IOException("Checksum is mismatch.");
            }
        } else {
            throw new IOException("Expect TAG_ROW_CHECKSUM but it was " + PlainBufferConsts.printTag(this.getLastTag()));
        }
        return row;
    }

    public PlainBufferSequenceInfo readSequenceInfo() throws IOException {
        if (!this.checkLastTagWas(12)) {
            throw new IOException("Expect TAG_SEQ_INFO but it was " + PlainBufferConsts.printTag(this.getLastTag()));
        }
        this.input.readRawLittleEndian32();
        this.readTag();
        PlainBufferSequenceInfo seq = new PlainBufferSequenceInfo();
        if (!this.checkLastTagWas(13)) {
            throw new IOException("Expect TAG_SEQ_INFO_EPOCH but it was " + PlainBufferConsts.printTag(this.getLastTag()));
        }
        seq.setEpoch(this.input.readUInt32());
        this.readTag();
        if (!this.checkLastTagWas(14)) {
            throw new IOException("Expect TAG_SEQ_INFO_TS but it was " + PlainBufferConsts.printTag(this.getLastTag()));
        }
        seq.setTimestamp(this.input.readInt64());
        this.readTag();
        if (!this.checkLastTagWas(15)) {
            throw new IOException("Expect TAG_SEQ_INFO_ROW_INDEX but it was " + PlainBufferConsts.printTag(this.getLastTag()));
        }
        seq.setRowIndex(this.input.readUInt32());
        this.readTag();
        return seq;
    }

    public List<PlainBufferRow> readRowsWithHeader() throws IOException {
        ArrayList<PlainBufferRow> rows = new ArrayList<PlainBufferRow>();
        if (this.readHeader() != 117) {
            logger.error("Invalid header from plain buffer: " + this.input.toString());
            throw new IOException("Invalid header from plain buffer.");
        }
        this.readTag();
        while (!this.input.isAtEnd()) {
            PlainBufferRow row = this.readRow();
            rows.add(row);
        }
        if (!this.input.isAtEnd()) {
            throw new IOException("");
        }
        return rows;
    }

    public List<PlainBufferRow> readRowsWithoutPk() throws IOException {
        ArrayList<PlainBufferRow> rows = new ArrayList<PlainBufferRow>();
        if (this.readHeader() != 117) {
            logger.error("Invalid header from plain buffer: " + this.input.toString());
            throw new IOException("Invalid header from plain buffer.");
        }
        this.readTag();
        while (!this.input.isAtEnd()) {
            PlainBufferRow row = this.readRow(false);
            rows.add(row);
        }
        if (!this.input.isAtEnd()) {
            throw new IOException("");
        }
        return rows;
    }
}

