/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCell;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferRow;
import java.io.IOException;

public class PlainBufferCrc8 {
    private static final int spaceSize = 256;
    private static byte[] crc8Table;
    private static byte[] crc8Table2;
    private static byte[] crc8Table4;

    public static byte crc8(byte crc, byte in) {
        crc = crc8Table[(crc ^ in) & 0xFF];
        return crc;
    }

    public static byte crc8(byte crc, int in) {
        for (int i = 0; i < 4; ++i) {
            crc = PlainBufferCrc8.crc8(crc, (byte)(in & 0xFF));
            in >>= 8;
        }
        return crc;
    }

    public static byte crc8(byte crc, long in) {
        for (int i = 0; i < 8; ++i) {
            crc = PlainBufferCrc8.crc8(crc, (byte)(in & 0xFFL));
            in >>= 8;
        }
        return crc;
    }

    public static byte crc8(byte crc, byte[] in) {
        return PlainBufferCrc8.crc8Fast(crc, in);
    }

    public static byte crc8Slow(byte crc, byte[] in) {
        for (int i = 0; i < in.length; ++i) {
            crc = PlainBufferCrc8.crc8(crc, in[i]);
        }
        return crc;
    }

    public static byte crc8Fast(byte crc, byte[] in) {
        byte crc1 = crc;
        byte crc2 = 0;
        byte crc3 = 0;
        byte crc4 = 0;
        int i = 0;
        while (i + 8 <= in.length) {
            crc1 = PlainBufferCrc8.crc8(crc1, in[i]);
            crc1 = PlainBufferCrc8.crc8(crc1, in[i + 1]);
            crc2 = PlainBufferCrc8.crc8((byte)0, in[i + 2]);
            crc2 = PlainBufferCrc8.crc8(crc2, in[i + 3]);
            crc3 = PlainBufferCrc8.crc8((byte)0, in[i + 4]);
            crc3 = PlainBufferCrc8.crc8(crc3, in[i + 5]);
            crc4 = PlainBufferCrc8.crc8((byte)0, in[i + 6]);
            crc4 = PlainBufferCrc8.crc8(crc4, in[i + 7]);
            crc1 = (byte)(crc8Table2[crc1 & 0xFF] ^ crc2);
            crc3 = (byte)(crc8Table2[crc3 & 0xFF] ^ crc4);
            crc1 = (byte)(crc8Table4[crc1 & 0xFF] ^ crc3);
            i += 8;
        }
        while (i < in.length) {
            crc1 = PlainBufferCrc8.crc8(crc1, in[i]);
            ++i;
        }
        return crc1;
    }

    public static byte getChecksum(byte crc, PlainBufferCell cell) throws IOException {
        if (cell.hasCellName()) {
            crc = PlainBufferCrc8.crc8(crc, cell.getNameRawData());
        }
        if (cell.hasCellValue()) {
            crc = cell.isPk() ? cell.getPkCellValue().getChecksum(crc) : cell.getCellValue().getChecksum(crc);
        }
        if (cell.hasCellTimestamp()) {
            crc = PlainBufferCrc8.crc8(crc, cell.getCellTimestamp());
        }
        if (cell.hasCellType()) {
            crc = PlainBufferCrc8.crc8(crc, cell.getCellType());
        }
        return crc;
    }

    public static byte getChecksum(byte crc, PlainBufferRow row) throws IOException {
        for (PlainBufferCell cell : row.getPrimaryKey()) {
            crc = PlainBufferCrc8.crc8(crc, cell.getChecksum());
        }
        for (PlainBufferCell cell : row.getCells()) {
            crc = PlainBufferCrc8.crc8(crc, cell.getChecksum());
        }
        byte del = 0;
        if (row.hasDeleteMarker()) {
            del = 1;
        }
        crc = PlainBufferCrc8.crc8(crc, del);
        return crc;
    }

    static {
        int i;
        crc8Table = new byte[256];
        crc8Table2 = new byte[256];
        crc8Table4 = new byte[256];
        for (i = 0; i < crc8Table.length; ++i) {
            byte x = (byte)i;
            for (int j = 8; j > 0; --j) {
                x = (byte)(x << 1 ^ ((x & 0x80) != 0 ? 7 : 0));
            }
            PlainBufferCrc8.crc8Table[i] = x;
        }
        for (i = 0; i < crc8Table.length; ++i) {
            PlainBufferCrc8.crc8Table2[i] = crc8Table[crc8Table[i] & 0xFF];
        }
        for (i = 0; i < crc8Table.length; ++i) {
            PlainBufferCrc8.crc8Table4[i] = crc8Table2[crc8Table2[i] & 0xFF];
        }
    }
}

