/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.aliyun.ots.thirdparty.com.google.protobuf.ByteString;

public class GeoDistanceQuery
implements Query {
    private final QueryType queryType = QueryType.QueryType_GeoDistanceQuery;
    private String fieldName;
    private String centerPoint;
    private double distanceInMeter;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(String centerPoint) {
        this.centerPoint = centerPoint;
    }

    public double getDistanceInMeter() {
        return this.distanceInMeter;
    }

    public void setDistanceInMeter(double distanceInMeter) {
        this.distanceInMeter = distanceInMeter;
    }

    @Override
    public QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public ByteString serialize() {
        return SearchQueryBuilder.buildGeoDistanceQuery(this).toByteString();
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements QueryBuilder {
        private String fieldName;
        private String centerPoint;
        private double distanceInMeter;

        private Builder() {
        }

        public Builder field(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder centerPoint(String centerPoint) {
            this.centerPoint = centerPoint;
            return this;
        }

        public Builder distanceInMeter(double distanceInMeter) {
            this.distanceInMeter = distanceInMeter;
            return this;
        }

        @Override
        public GeoDistanceQuery build() {
            GeoDistanceQuery geoDistanceQuery = new GeoDistanceQuery();
            geoDistanceQuery.setCenterPoint(this.centerPoint);
            geoDistanceQuery.setDistanceInMeter(this.distanceInMeter);
            geoDistanceQuery.setFieldName(this.fieldName);
            return geoDistanceQuery;
        }
    }
}

