/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeserieswriter;

import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesTableRow;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class TimeseriesWriterResult {
    private boolean isAllFinished = true;
    private final int totalCount;
    private final AtomicReferenceArray<TimeseriesRowChangeStatus> timeseriesRowChangeStatusList;

    public TimeseriesWriterResult(int totalCount, AtomicReferenceArray<TimeseriesRowChangeStatus> timeseriesRowChangeStatusList) {
        this.totalCount = totalCount;
        this.timeseriesRowChangeStatusList = timeseriesRowChangeStatusList;
    }

    public List<TimeseriesRowChangeStatus> getSucceedRows() {
        LinkedList<TimeseriesRowChangeStatus> succeed = new LinkedList<TimeseriesRowChangeStatus>();
        for (int i = 0; i < this.timeseriesRowChangeStatusList.length(); ++i) {
            TimeseriesRowChangeStatus timeseriesRowChangeStatus = this.timeseriesRowChangeStatusList.get(i);
            if (!timeseriesRowChangeStatus.isSucceed()) continue;
            succeed.add(timeseriesRowChangeStatus);
        }
        return succeed;
    }

    public List<TimeseriesRowChangeStatus> getFailedRows() {
        LinkedList<TimeseriesRowChangeStatus> failed = new LinkedList<TimeseriesRowChangeStatus>();
        for (int i = 0; i < this.timeseriesRowChangeStatusList.length(); ++i) {
            TimeseriesRowChangeStatus timeseriesRowChangeStatus = this.timeseriesRowChangeStatusList.get(i);
            if (timeseriesRowChangeStatus.isSucceed()) continue;
            failed.add(timeseriesRowChangeStatus);
        }
        return failed;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean isAllFinished() {
        return this.isAllFinished;
    }

    public boolean isAllSucceed() {
        LinkedList<TimeseriesRowChangeStatus> failed = new LinkedList<TimeseriesRowChangeStatus>();
        for (int i = 0; i < this.timeseriesRowChangeStatusList.length(); ++i) {
            TimeseriesRowChangeStatus timeseriesRowChangeStatus = this.timeseriesRowChangeStatusList.get(i);
            if (timeseriesRowChangeStatus.isSucceed()) continue;
            failed.add(timeseriesRowChangeStatus);
        }
        return failed.size() == 0;
    }

    public static class TimeseriesRowChangeStatus {
        private boolean succeed;
        private Exception exception;
        private TimeseriesTableRow timeseriesTableRow;

        public TimeseriesRowChangeStatus(boolean succeed, TimeseriesTableRow timeseriesTableRow, Exception exception) {
            this.succeed = succeed;
            this.timeseriesTableRow = timeseriesTableRow;
            this.exception = exception;
        }

        public boolean isSucceed() {
            return this.succeed;
        }

        public Exception getException() {
            return this.exception;
        }

        public TimeseriesTableRow getTimeseriesTableRow() {
            return this.timeseriesTableRow;
        }
    }
}

