/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeserieswriter.dispatch;

import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesKey;
import com.alicloud.openservices.tablestore.model.timeseries.TimeseriesRow;
import com.alicloud.openservices.tablestore.timeserieswriter.dispatch.TimeseriesBaseDispatcher;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeseriesHashPKDispatcher
extends TimeseriesBaseDispatcher {
    private static Logger logger = LoggerFactory.getLogger(TimeseriesHashPKDispatcher.class);
    private AtomicLong counter = new AtomicLong(0L);
    private int bucketCount;

    public TimeseriesHashPKDispatcher(int bucketCount) {
        super(bucketCount);
        this.bucketCount = Math.min(bucketCount, 256);
    }

    @Override
    public int getDispatchIndex(TimeseriesRow timeseriesRow) {
        if (this.bucketCount == 1) {
            this.addBucketCount(0);
            return 0;
        }
        TimeseriesKey key = timeseriesRow.getTimeseriesKey();
        try {
            MessageDigest md5 = MessageDigest.getInstance("md5");
            md5.update(key.getMeasurementName().getBytes());
            md5.update(key.getDataSource().getBytes());
            for (Map.Entry<String, String> entry : key.getTags().entrySet()) {
                md5.update(entry.getValue().getBytes());
            }
            byte[] digest = md5.digest();
            int bucketIndex = digest[0];
            int capacity = 256 / this.bucketCount;
            bucketIndex = ((bucketIndex + 128) / capacity + this.bucketCount) % this.bucketCount;
            this.addBucketCount(bucketIndex);
            return bucketIndex;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Failed while get hash dispatch index,:", (Throwable)e);
            return 0;
        }
        catch (IllegalArgumentException e) {
            logger.error("Failed while get hash dispatch index,:", (Throwable)e);
            return 0;
        }
    }
}

