/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer.handle;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.CallbackFactory;
import com.alicloud.openservices.tablestore.writer.RequestManager;
import com.alicloud.openservices.tablestore.writer.RowChangeWithGroup;
import com.alicloud.openservices.tablestore.writer.RowWriteResult;
import com.alicloud.openservices.tablestore.writer.WriterConfig;
import com.alicloud.openservices.tablestore.writer.config.BucketConfig;
import com.alicloud.openservices.tablestore.writer.handle.FlushCallbackFactory;
import com.alicloud.openservices.tablestore.writer.handle.WriterHandleStatistics;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRequestManager
implements RequestManager {
    private static Logger logger = LoggerFactory.getLogger(BaseRequestManager.class);
    protected AsyncClientInterface ots;
    protected BucketConfig bucketConfig;
    protected WriterConfig writerConfig;
    protected Semaphore callbackSemaphore;
    protected TableStoreCallback<RowChange, RowWriteResult> callback;
    protected Executor executor;
    protected WriterHandleStatistics writerStatistics;
    protected Semaphore bucketSemaphore;
    protected CallbackFactory callbackFactory;
    protected List<RowChangeWithGroup> rowChangeWithGroups = new LinkedList<RowChangeWithGroup>();
    protected int totalSize;
    protected int totalRowsCount;
    protected boolean allowDuplicatedRowInBatchRequest;
    protected ConcurrentSkipListSet<PrimaryKey> sendingPrimarykeys = new ConcurrentSkipListSet();

    public BaseRequestManager(AsyncClientInterface ots, WriterConfig writerConfig, BucketConfig bucketConfig, Executor executor, WriterHandleStatistics writerStatistics, TableStoreCallback<RowChange, RowWriteResult> callback, Semaphore callbackSemaphore, Semaphore bucketSemaphore) {
        this.ots = ots;
        this.writerConfig = writerConfig;
        this.bucketConfig = bucketConfig;
        this.executor = executor;
        this.writerStatistics = writerStatistics;
        this.callback = callback;
        this.callbackSemaphore = callbackSemaphore;
        this.bucketSemaphore = bucketSemaphore;
        this.totalSize = 0;
        this.totalRowsCount = 0;
        this.allowDuplicatedRowInBatchRequest = bucketConfig.isAllowDuplicateRowInBatchRequest();
        this.callbackFactory = new FlushCallbackFactory(ots, callbackSemaphore, callback, executor, writerStatistics, bucketConfig, bucketSemaphore);
    }

    @Override
    public boolean appendRowChange(RowChangeWithGroup rowChangeWithGroup) {
        if (this.totalSize + rowChangeWithGroup.rowChange.getDataSize() > this.writerConfig.getMaxBatchSize()) {
            return false;
        }
        if (this.totalRowsCount >= this.writerConfig.getMaxBatchRowsCount()) {
            return false;
        }
        if (!this.allowDuplicatedRowInBatchRequest) {
            if (this.sendingPrimarykeys.contains(rowChangeWithGroup.rowChange.getPrimaryKey())) {
                return false;
            }
            this.sendingPrimarykeys.add(rowChangeWithGroup.rowChange.getPrimaryKey());
        }
        this.rowChangeWithGroups.add(rowChangeWithGroup);
        this.totalSize += rowChangeWithGroup.rowChange.getDataSize();
        ++this.totalRowsCount;
        return true;
    }

    @Override
    public int getTotalRowsCount() {
        return this.totalRowsCount;
    }

    @Override
    public void clear() {
        this.rowChangeWithGroups.clear();
        this.sendingPrimarykeys.clear();
        this.totalSize = 0;
        this.totalRowsCount = 0;
    }
}

