/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.model.SSEKeyType;

public class SSESpecification
implements Jsonizable {
    private boolean enable = false;
    private OptionalValue<SSEKeyType> keyType = new OptionalValue("KeyType");

    public SSESpecification(boolean enable) {
        if (enable) {
            throw new ClientException("Key type is required when enable is true.");
        }
        this.setEnable(enable);
    }

    public SSESpecification(boolean enable, SSEKeyType keyType) {
        if (!enable) {
            throw new ClientException("Key type cannot be set when enable is false.");
        }
        this.setEnable(enable);
        this.setKeyType(keyType);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public SSEKeyType getKeyType() {
        return this.keyType.getValue();
    }

    public void setKeyType(SSEKeyType keyType) {
        this.keyType.setValue(keyType);
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        sb.append('{');
        sb.append(newline);
        sb.append("\"Enable\": ");
        sb.append(this.enable);
        if (this.keyType.isValueSet()) {
            sb.append(",");
            sb.append(newline);
            sb.append("\"KeyType\": ");
            sb.append(this.keyType.getValue().toString());
            sb.append(newline);
        }
        sb.append("}");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Enable: ");
        sb.append(this.enable);
        if (this.keyType.isValueSet()) {
            sb.append(", KeyType: ");
            sb.append(this.keyType.getValue().toString());
        }
        return sb.toString();
    }
}

