/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search;

import com.alicloud.openservices.tablestore.model.search.Collapse;
import com.alicloud.openservices.tablestore.model.search.agg.Aggregation;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupBy;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByBuilder;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.sort.Sort;
import java.util.ArrayList;
import java.util.List;

public class SearchQuery {
    private Integer offset;
    private Integer limit;
    private Query query;
    private Collapse collapse;
    private Sort sort;
    private boolean getTotalCount = false;
    private List<Aggregation> aggregationList;
    private List<GroupBy> groupByList;
    private byte[] token;

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<Aggregation> getAggregationList() {
        return this.aggregationList;
    }

    public void setAggregationList(List<Aggregation> aggregationList) {
        this.aggregationList = aggregationList;
    }

    public List<GroupBy> getGroupByList() {
        return this.groupByList;
    }

    public void setGroupByList(List<GroupBy> groupByList) {
        this.groupByList = groupByList;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public SearchQuery setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SearchQuery setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public SearchQuery setQuery(Query query) {
        this.query = query;
        return this;
    }

    public Collapse getCollapse() {
        return this.collapse;
    }

    public SearchQuery setCollapse(Collapse collapse) {
        this.collapse = collapse;
        return this;
    }

    public Sort getSort() {
        return this.sort;
    }

    public SearchQuery setSort(Sort sort) {
        this.sort = sort;
        return this;
    }

    public boolean isGetTotalCount() {
        return this.getTotalCount;
    }

    public void setGetTotalCount(boolean getTotalCount) {
        this.getTotalCount = getTotalCount;
    }

    public byte[] getToken() {
        return this.token;
    }

    public void setToken(byte[] token) {
        this.token = token;
        this.sort = null;
    }

    public SearchQuery() {
    }

    private SearchQuery(Builder builder) {
        this.setOffset(builder.offset);
        this.setLimit(builder.limit);
        this.setQuery(builder.query);
        this.setCollapse(builder.collapse);
        this.setSort(builder.sort);
        this.setGetTotalCount(builder.getTotalCount);
        this.setAggregationList(builder.aggregationList);
        this.setGroupByList(builder.groupByList);
        this.setToken(builder.token);
    }

    public static final class Builder {
        private Integer offset;
        private Integer limit;
        private Query query;
        private Collapse collapse;
        private Sort sort;
        private boolean getTotalCount;
        private List<Aggregation> aggregationList;
        private List<GroupBy> groupByList;
        private byte[] token;

        private Builder() {
        }

        public Builder offset(int val) {
            this.offset = val;
            return this;
        }

        public Builder limit(int val) {
            this.limit = val;
            return this;
        }

        public Builder query(QueryBuilder queryBuilder) {
            this.query = queryBuilder.build();
            return this;
        }

        public Builder collapse(String fieldName) {
            this.collapse = new Collapse(fieldName);
            return this;
        }

        public Builder sort(Sort val) {
            this.sort = val;
            return this;
        }

        public Builder getTotalCount(boolean val) {
            this.getTotalCount = val;
            return this;
        }

        public Builder addAggregation(AggregationBuilder aggregationBuilder) {
            if (this.aggregationList == null) {
                this.aggregationList = new ArrayList<Aggregation>();
            }
            this.aggregationList.add(aggregationBuilder.build());
            return this;
        }

        public Builder addGroupBy(GroupByBuilder groupByBuilder) {
            if (this.groupByList == null) {
                this.groupByList = new ArrayList<GroupBy>();
            }
            this.groupByList.add(groupByBuilder.build());
            return this;
        }

        public Builder token(byte[] val) {
            this.token = val;
            return this;
        }

        public SearchQuery build() {
            return new SearchQuery(this);
        }
    }
}

