/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.groupby;

import com.alicloud.openservices.tablestore.core.protocol.SearchGroupByBuilder;
import com.alicloud.openservices.tablestore.model.search.agg.Aggregation;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupBy;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByType;
import com.alicloud.openservices.tablestore.model.search.groupby.Range;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public class GroupByRange
implements GroupBy {
    private String groupByName;
    private String fieldName;
    private List<Range> ranges;
    private List<Aggregation> subAggregations;
    private List<GroupBy> subGroupBys;

    private GroupByRange(Builder builder) {
        this.groupByName = builder.groupByName;
        this.fieldName = builder.fieldName;
        this.ranges = builder.ranges;
        this.subAggregations = builder.subAggregations;
        this.subGroupBys = builder.subGroupBys;
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getGroupByName() {
        return this.groupByName;
    }

    @Override
    public GroupByType getGroupByType() {
        return GroupByType.GROUP_BY_RANGE;
    }

    @Override
    public ByteString serialize() {
        return SearchGroupByBuilder.buildGroupByRange(this).toByteString();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public List<Aggregation> getSubAggregations() {
        return this.subAggregations;
    }

    public List<GroupBy> getSubGroupBys() {
        return this.subGroupBys;
    }

    public static final class Builder
    implements GroupByBuilder {
        private String groupByName;
        private String fieldName;
        private List<Range> ranges;
        private List<Aggregation> subAggregations;
        private List<GroupBy> subGroupBys;

        private Builder() {
        }

        public Builder groupByName(String groupByName) {
            this.groupByName = groupByName;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder addRange(double from, double to) {
            if (this.ranges == null) {
                this.ranges = new ArrayList<Range>();
            }
            this.ranges.add(new Range(from, to));
            return this;
        }

        public Builder addSubAggregation(AggregationBuilder builder) {
            if (this.subAggregations == null) {
                this.subAggregations = new ArrayList<Aggregation>();
            }
            this.subAggregations.add(builder.build());
            return this;
        }

        public Builder addSubGroupBy(GroupByBuilder builder) {
            if (this.subGroupBys == null) {
                this.subGroupBys = new ArrayList<GroupBy>();
            }
            this.subGroupBys.add(builder.build());
            return this;
        }

        @Override
        public GroupByRange build() {
            return new GroupByRange(this);
        }
    }
}

