/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.protocol.Search;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationResults;
import com.alicloud.openservices.tablestore.model.search.agg.AvgAggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.CountAggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.DistinctCountAggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.MaxAggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.MinAggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.SumAggregationResult;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;

class SearchAggregationResultBuilder {
    SearchAggregationResultBuilder() {
    }

    private static AvgAggregationResult buildAvgAggregationResult(String aggName, ByteString aggBody) throws InvalidProtocolBufferException {
        Search.AvgAggregationResult aggResult = Search.AvgAggregationResult.parseFrom(aggBody);
        AvgAggregationResult result = new AvgAggregationResult();
        result.setAggName(aggName);
        result.setValue(aggResult.getValue());
        return result;
    }

    private static MaxAggregationResult buildMaxAggregationResult(String aggName, ByteString aggBody) throws InvalidProtocolBufferException {
        Search.MaxAggregationResult aggResult = Search.MaxAggregationResult.parseFrom(aggBody);
        MaxAggregationResult result = new MaxAggregationResult();
        result.setAggName(aggName);
        result.setValue(aggResult.getValue());
        return result;
    }

    private static MinAggregationResult buildMinAggregationResult(String aggName, ByteString aggBody) throws InvalidProtocolBufferException {
        Search.MinAggregationResult aggResult = Search.MinAggregationResult.parseFrom(aggBody);
        MinAggregationResult result = new MinAggregationResult();
        result.setAggName(aggName);
        result.setValue(aggResult.getValue());
        return result;
    }

    private static SumAggregationResult buildSumAggregationResult(String aggName, ByteString aggBody) throws InvalidProtocolBufferException {
        Search.SumAggregationResult aggResult = Search.SumAggregationResult.parseFrom(aggBody);
        SumAggregationResult result = new SumAggregationResult();
        result.setAggName(aggName);
        result.setValue(aggResult.getValue());
        return result;
    }

    private static DistinctCountAggregationResult buildDistinctCountAggregationResult(String aggName, ByteString aggBody) throws InvalidProtocolBufferException {
        Search.DistinctCountAggregationResult aggResult = Search.DistinctCountAggregationResult.parseFrom(aggBody);
        DistinctCountAggregationResult result = new DistinctCountAggregationResult();
        result.setAggName(aggName);
        result.setValue(aggResult.getValue());
        return result;
    }

    private static CountAggregationResult buildCountAggregationResult(String aggName, ByteString aggBody) throws InvalidProtocolBufferException {
        Search.CountAggregationResult aggResult = Search.CountAggregationResult.parseFrom(aggBody);
        CountAggregationResult result = new CountAggregationResult();
        result.setAggName(aggName);
        result.setValue(aggResult.getValue());
        return result;
    }

    private static AggregationResult buildAggResult(Search.AggregationResult aggregationResult) throws InvalidProtocolBufferException {
        switch (aggregationResult.getType()) {
            case AGG_AVG: {
                return SearchAggregationResultBuilder.buildAvgAggregationResult(aggregationResult.getName(), aggregationResult.getAggResult());
            }
            case AGG_MAX: {
                return SearchAggregationResultBuilder.buildMaxAggregationResult(aggregationResult.getName(), aggregationResult.getAggResult());
            }
            case AGG_MIN: {
                return SearchAggregationResultBuilder.buildMinAggregationResult(aggregationResult.getName(), aggregationResult.getAggResult());
            }
            case AGG_SUM: {
                return SearchAggregationResultBuilder.buildSumAggregationResult(aggregationResult.getName(), aggregationResult.getAggResult());
            }
            case AGG_DISTINCT_COUNT: {
                return SearchAggregationResultBuilder.buildDistinctCountAggregationResult(aggregationResult.getName(), aggregationResult.getAggResult());
            }
            case AGG_COUNT: {
                return SearchAggregationResultBuilder.buildCountAggregationResult(aggregationResult.getName(), aggregationResult.getAggResult());
            }
        }
        throw new ClientException("unsupported aggType: " + (Object)((Object)aggregationResult.getType()));
    }

    static AggregationResults buildAggregationResults(Search.AggregationsResult aggregationsResult) throws InvalidProtocolBufferException {
        AggregationResults aggregationResults = new AggregationResults();
        HashMap<String, AggregationResult> map = new HashMap<String, AggregationResult>();
        for (Search.AggregationResult s : aggregationsResult.getAggResultsList()) {
            map.put(s.getName(), SearchAggregationResultBuilder.buildAggResult(s));
        }
        aggregationResults.setResultMap(map);
        return aggregationResults;
    }

    static AggregationResults buildAggregationResultsFromByteString(ByteString agg) throws InvalidProtocolBufferException {
        Search.AggregationsResult aggregationsResult = Search.AggregationsResult.parseFrom(agg);
        return SearchAggregationResultBuilder.buildAggregationResults(aggregationsResult);
    }
}

