/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.model.BulkExportRequest;
import com.alicloud.openservices.tablestore.model.BulkExportResponse;
import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.DataBlockType;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.SimpleRowMatrixBlockParser;
import com.alicloud.openservices.tablestore.model.tunnel.BulkExportQueryCriteria;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class SimpleRowMatrixBlockRowIterator
implements Iterator<Long> {
    private SyncClientInterface client;
    private BulkExportQueryCriteria parameter;
    private BulkExportResponse result;
    private SimpleRowMatrixBlockParser block;
    private Map<String, Integer> fieldNames;
    private long index = 0L;
    private boolean verifyFieldNames;

    public SimpleRowMatrixBlockRowIterator(SyncClientInterface client, BulkExportQueryCriteria parameter, boolean verifyFieldNames) {
        this.client = client;
        this.parameter = parameter;
        this.verifyFieldNames = verifyFieldNames;
        this.fetchData(this.buildRequest());
    }

    private BulkExportRequest buildRequest() {
        BulkExportQueryCriteria criteria = new BulkExportQueryCriteria(this.parameter.getTableName());
        if (this.parameter.hasSetFilter()) {
            criteria.setFilter(this.parameter.getFilter());
        }
        if (this.result == null) {
            criteria.setInclusiveStartPrimaryKey(this.parameter.getInclusiveStartPrimaryKey());
        } else {
            criteria.setInclusiveStartPrimaryKey(this.result.getNextStartPrimaryKey());
        }
        criteria.setExclusiveEndPrimaryKey(this.parameter.getExclusiveEndPrimaryKey());
        criteria.setDataBlockType(DataBlockType.DBT_SIMPLE_ROW_MATRIX);
        criteria.addColumnsToGet(this.parameter.getColumnsToGet());
        if (this.parameter.hasSetFilter()) {
            criteria.setFilter(this.parameter.getFilter());
        }
        return new BulkExportRequest(criteria);
    }

    private void fetchData(BulkExportRequest request) {
        block4: {
            block3: {
                this.result = this.client.bulkExport(request);
                this.block = new SimpleRowMatrixBlockParser(this.result.getRows());
                if (this.fieldNames != null) break block3;
                String[] fns = this.block.parseFieldNames();
                this.fieldNames = new HashMap<String, Integer>(fns.length);
                for (int i = 0; i < fns.length; ++i) {
                    this.fieldNames.put(fns[i], i);
                }
                break block4;
            }
            if (!this.verifyFieldNames) break block4;
            String[] fns = this.block.parseFieldNames();
            if (fns.length != this.fieldNames.size()) {
                throw new ClientException("Inconsistent field name count");
            }
            for (int i = 0; i < fns.length; ++i) {
                Integer idx = this.fieldNames.get(fns[i]);
                if (idx != null && idx == i) continue;
                throw new ClientException("Inconsistent field name:" + fns[i]);
            }
        }
    }

    private boolean isBufferHasMoreData() {
        return this.block != null && this.block.hasNext();
    }

    private long getNextFromBuffer() {
        this.block.next();
        return this.index++;
    }

    @Override
    public boolean hasNext() {
        if (this.isBufferHasMoreData()) {
            return true;
        }
        PrimaryKey nextToken = this.result.getNextStartPrimaryKey();
        while (nextToken != null && !nextToken.isEmpty()) {
            this.fetchData(this.buildRequest());
            if (this.isBufferHasMoreData()) {
                return true;
            }
            nextToken = this.result.getNextStartPrimaryKey();
        }
        return false;
    }

    @Override
    public Long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.getNextFromBuffer();
    }

    public int locate(String fieldName) {
        Integer x = this.fieldNames.get(fieldName);
        if (x == null) {
            throw new ClientException("Can't find the field by name:" + fieldName);
        }
        return x;
    }

    public Row getRow() {
        return this.block.getRow();
    }

    public boolean getBoolean(String fieldName) {
        int idx = this.locate(fieldName);
        return this.block.getBoolean(idx);
    }

    public boolean getBoolean(int index) {
        return this.block.getBoolean(index);
    }

    public String getString(String fieldName) {
        int idx = this.locate(fieldName);
        return this.block.getString(idx);
    }

    public String getString(int index) {
        return this.block.getString(index);
    }

    public long getLong(String fieldName) {
        int idx = this.locate(fieldName);
        return this.block.getLong(idx);
    }

    public long getLong(int index) {
        return this.block.getLong(index);
    }

    public double getDouble(String fieldName) {
        int idx = this.locate(fieldName);
        return this.block.getDouble(idx);
    }

    public double getDouble(int index) {
        return this.block.getDouble(index);
    }

    public byte[] getBinary(String fieldName) {
        int idx = this.locate(fieldName);
        return this.block.getBinary(idx);
    }

    public byte[] getBinary(int index) {
        return this.block.getBinary(index);
    }

    public boolean isNull(String fieldName) {
        int idx = this.locate(fieldName);
        return this.block.isNull(idx);
    }

    public boolean isNull(int index) {
        return this.block.isNull(index);
    }

    public Object getObject(String fieldName) {
        int idx = this.locate(fieldName);
        return this.block.getObject(idx);
    }

    public Object getObject(int index) {
        return this.block.getObject(index);
    }

    public ColumnType getFieldType(String fieldName) {
        int idx = this.locate(fieldName);
        return this.block.getColumnType(idx);
    }

    public ColumnType getFieldType(int index) {
        return this.block.getColumnType(index);
    }

    @Override
    public void remove() {
        throw new ClientException("SimpleRowMatrixBlockRowIterator do not support remove().");
    }
}

