/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.Request;
import com.alicloud.openservices.tablestore.model.search.SearchQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SearchRequest
implements Request {
    private String tableName;
    private String indexName;
    private SearchQuery searchQuery;
    private ColumnsToGet columnsToGet;
    private List<PrimaryKey> routingValues;

    public SearchRequest() {
    }

    public SearchRequest(String tableName, String indexName, SearchQuery searchQuery) {
        this.tableName = tableName;
        this.indexName = indexName;
        this.searchQuery = searchQuery;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public SearchQuery getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(SearchQuery searchQuery) {
        this.searchQuery = searchQuery;
    }

    public ColumnsToGet getColumnsToGet() {
        return this.columnsToGet;
    }

    public void setColumnsToGet(ColumnsToGet columnsToGet) {
        this.columnsToGet = columnsToGet;
    }

    public List<PrimaryKey> getRoutingValues() {
        return this.routingValues;
    }

    public void setRoutingValues(List<PrimaryKey> routingValues) {
        this.routingValues = routingValues;
    }

    @Override
    public String getOperationName() {
        return "Search";
    }

    public String getRequestInfo(boolean prettyFormat) {
        if (prettyFormat) {
            return JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.IgnoreErrorGetter, SerializerFeature.PrettyFormat});
        }
        return JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.IgnoreErrorGetter});
    }

    public void printRequestInfo() {
        System.out.println(this.getRequestInfo(true));
    }

    private SearchRequest(Builder builder) {
        this.setTableName(builder.tableName);
        this.setIndexName(builder.indexName);
        this.setSearchQuery(builder.searchQuery);
        this.setColumnsToGet(builder.columnsToGet);
        this.setRoutingValues(builder.routingValues);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String tableName;
        private String indexName;
        private SearchQuery searchQuery;
        private ColumnsToGet columnsToGet;
        private List<PrimaryKey> routingValues;

        private Builder() {
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder searchQuery(SearchQuery searchQuery) {
            this.searchQuery = searchQuery;
            return this;
        }

        public Builder addColumnsToGet(String ... columnsToGet) {
            if (this.columnsToGet == null) {
                this.columnsToGet = new ColumnsToGet();
                this.columnsToGet.columns = new ArrayList();
            }
            this.columnsToGet.getColumns().addAll(Arrays.asList(columnsToGet));
            return this;
        }

        public Builder addColumnsToGet(List<String> columnsToGetList) {
            if (this.columnsToGet == null) {
                this.columnsToGet = new ColumnsToGet();
                this.columnsToGet.columns = new ArrayList();
            }
            this.columnsToGet.getColumns().addAll(columnsToGetList);
            return this;
        }

        public Builder returnAllColumns(boolean returnAll) {
            if (this.columnsToGet == null) {
                this.columnsToGet = new ColumnsToGet();
            }
            this.columnsToGet.setReturnAll(returnAll);
            return this;
        }

        public Builder addRoutingValue(PrimaryKeyBuilder primaryKeyBuilder) {
            if (this.routingValues == null) {
                this.routingValues = new ArrayList<PrimaryKey>();
            }
            this.routingValues.add(primaryKeyBuilder.build());
            return this;
        }

        public Builder addRoutingValues(List<PrimaryKey> primaryKeys) {
            if (this.routingValues == null) {
                this.routingValues = new ArrayList<PrimaryKey>();
            }
            this.routingValues.addAll(primaryKeys);
            return this;
        }

        public SearchRequest build() {
            return new SearchRequest(this);
        }
    }

    public static class ColumnsToGet {
        private List<String> columns;
        private boolean returnAll;

        public List<String> getColumns() {
            return this.columns;
        }

        public void setColumns(List<String> columns) {
            this.columns = columns;
        }

        public boolean isReturnAll() {
            return this.returnAll;
        }

        public void setReturnAll(boolean returnAll) {
            this.returnAll = returnAll;
        }
    }
}

