/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public class BoolQuery
implements Query {
    private List<Query> mustQueries;
    private List<Query> mustNotQueries;
    private List<Query> filterQueries;
    private List<Query> shouldQueries;
    private Integer minimumShouldMatch;

    public List<Query> getMustQueries() {
        return this.mustQueries;
    }

    public void setMustQueries(List<Query> mustQueries) {
        this.mustQueries = mustQueries;
    }

    public List<Query> getMustNotQueries() {
        return this.mustNotQueries;
    }

    public void setMustNotQueries(List<Query> mustNotQueries) {
        this.mustNotQueries = mustNotQueries;
    }

    public List<Query> getFilterQueries() {
        return this.filterQueries;
    }

    public void setFilterQueries(List<Query> filterQueries) {
        this.filterQueries = filterQueries;
    }

    public List<Query> getShouldQueries() {
        return this.shouldQueries;
    }

    public void setShouldQueries(List<Query> shouldQueries) {
        this.shouldQueries = shouldQueries;
    }

    public Integer getMinimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public void setMinimumShouldMatch(int minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.QueryType_BoolQuery;
    }

    @Override
    public ByteString serialize() {
        return SearchQueryBuilder.buildBoolQuery(this).toByteString();
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements QueryBuilder {
        private List<Query> mustQueries;
        private List<Query> mustNotQueries;
        private List<Query> filterQueries;
        private List<Query> shouldQueries;
        private Integer minimumShouldMatch;

        public Builder must(QueryBuilder queryBuilder) {
            if (this.mustQueries == null) {
                this.mustQueries = new ArrayList<Query>();
            }
            this.mustQueries.add(queryBuilder.build());
            return this;
        }

        public Builder mustNot(QueryBuilder queryBuilder) {
            if (this.mustNotQueries == null) {
                this.mustNotQueries = new ArrayList<Query>();
            }
            this.mustNotQueries.add(queryBuilder.build());
            return this;
        }

        public Builder filter(QueryBuilder queryBuilder) {
            if (this.filterQueries == null) {
                this.filterQueries = new ArrayList<Query>();
            }
            this.filterQueries.add(queryBuilder.build());
            return this;
        }

        public Builder should(QueryBuilder queryBuilder) {
            if (this.shouldQueries == null) {
                this.shouldQueries = new ArrayList<Query>();
            }
            this.shouldQueries.add(queryBuilder.build());
            return this;
        }

        public Builder minimumShouldMatch(int value) {
            this.minimumShouldMatch = value;
            return this;
        }

        @Override
        public BoolQuery build() {
            BoolQuery boolQuery = new BoolQuery();
            boolQuery.setMustQueries(this.mustQueries);
            boolQuery.setMustNotQueries(this.mustNotQueries);
            boolQuery.setFilterQueries(this.filterQueries);
            boolQuery.setShouldQueries(this.shouldQueries);
            boolQuery.minimumShouldMatch = this.minimumShouldMatch;
            return boolQuery;
        }
    }
}

