/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.jdbc;

import com.aliyun.polardb.Driver;
import com.aliyun.polardb.core.ParameterList;
import com.aliyun.polardb.core.Query;
import com.aliyun.polardb.core.v3.SimpleParameterList;
import com.aliyun.polardb.ext.PolarCompDecorater;
import com.aliyun.polardb.jdbc.BatchResultHandler;
import com.aliyun.polardb.jdbc.CallableBatchResultHandler;
import com.aliyun.polardb.jdbc.PgConnection;
import com.aliyun.polardb.jdbc.PgPreparedStatement;
import com.aliyun.polardb.jdbc.TypeInfoCache;
import com.aliyun.polardb.util.GT;
import com.aliyun.polardb.util.PSQLException;
import com.aliyun.polardb.util.PSQLState;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

class PgCallableStatement
extends PgPreparedStatement
implements CallableStatement {
    private boolean isFunction;
    private int[] functionReturnType;
    private int[] testReturn;
    private boolean returnTypeSet;
    protected Object[] callResult;
    private int lastIndex = 0;
    private boolean atLeastOneNamedParameter = false;
    private List<String> namedParameters = new ArrayList<String>();
    private static String NAMED_PARAMETER_INDICATOR = "=>";
    private int namedParameterCount = 0;
    public final int DB_SPECIFIC_COMPTABILE_CURSOR = -10;

    PgCallableStatement(PgConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, connection.borrowCallableQuery(sql), false, rsType, rsConcurrency, rsHoldability);
        if (this.preparedQuery.isUnamedProc) {
            sql = this.preparedQuery.fakeUnamedProcSql;
        }
        this.isFunction = this.preparedQuery.isFunction;
        this.outParmBeforeFunc = this.preparedQuery.outParmBeforeFunc;
        this.isCallable = this.preparedQuery.isCallable;
        this.parseNamedParameters(sql);
        if (this.isFunction) {
            int inParamCount = this.preparedParameters.getInParameterCount() + 1;
            this.testReturn = new int[inParamCount];
            this.functionReturnType = new int[inParamCount];
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.isFunction) {
            this.executeWithFlags(0);
            return 0;
        }
        return super.executeUpdate();
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(i, map);
    }

    @Override
    public Object getObject(String s, Map<String, Class<?>> map) throws SQLException {
        return this.getObjectImpl(s, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        this.execute(this.preparedQuery, this.preparedParameters, flags);
        if (this.isFunction || this.isCallable) {
            if (!this.returnTypeSet) {
                if (this.result != null) {
                    PgCallableStatement pgCallableStatement = this;
                    synchronized (pgCallableStatement) {
                        this.checkClosed();
                        ResultSet rs = this.result.getResultSet();
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    this.result = null;
                }
                return false;
            }
            if (this.result == null || this.result.getResultSet() == null) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
            }
            ResultSet rs = this.result.getResultSet();
            if (!rs.next()) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with nothing returned.", new Object[0]), PSQLState.NO_DATA);
            }
            int cols = rs.getMetaData().getColumnCount();
            int outParameterCount = this.preparedParameters.getParameterCount();
            if (this.outParmBeforeFunc) {
                ++outParameterCount;
            }
            if (cols != outParameterCount) {
                throw new PSQLException(GT.tr("A CallableStatement was executed with an invalid number of parameters", new Object[0]), PSQLState.SYNTAX_ERROR);
            }
            this.lastIndex = 0;
            this.callResult = new Object[this.preparedParameters.getParameterCount() + 1];
            int i = 0;
            int j = 0;
            while (i < cols) {
                this.callResult[j] = rs.getObject(i + 1);
                int columnType = rs.getMetaData().getColumnType(i + 1);
                String typeName = rs.getMetaData().getColumnTypeName(i + 1);
                String registeredTypeName = null;
                if (this.preparedParameters instanceof SimpleParameterList) {
                    int paramIndex = i + 1;
                    registeredTypeName = this.isFunction ? (--paramIndex > 0 ? ((SimpleParameterList)this.preparedParameters).getOutParameterTypeName(paramIndex) : ((SimpleParameterList)this.preparedParameters).getReturnTypeName()) : ((SimpleParameterList)this.preparedParameters).getOutParameterTypeName(paramIndex);
                }
                if (columnType != 0 && columnType != this.functionReturnType[j]) {
                    if (columnType == 8 && this.functionReturnType[j] == 7) {
                        if (this.callResult[j] != null) {
                            this.callResult[j] = Float.valueOf(((Double)this.callResult[j]).floatValue());
                        }
                    } else if (!(columnType == 1111 && this.functionReturnType[j] == 2006 || columnType == 2012 && this.functionReturnType[j] == 1111 || columnType == 2012 && this.functionReturnType[j] == 2006)) {
                        if (PolarCompDecorater.getInstance().isPolarComp() && columnType == 2 && this.functionReturnType[j] == 4) {
                            if (this.callResult[j] != null) {
                                this.callResult[j] = ((BigDecimal)this.callResult[j]).intValue();
                            }
                        } else {
                            throw new PSQLException(GT.tr("A CallableStatement function was executed and the out parameter {0} was of type {1} however type {2} was registered.", i + 1, "java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType[j]), PSQLState.DATA_TYPE_MISMATCH);
                        }
                    }
                }
                if (registeredTypeName != null && typeName != null && !TypeInfoCache.compareTypeNames(registeredTypeName, typeName)) {
                    throw new PSQLException(GT.tr("A CallableStatement function was executed and the return type name was {0} however type name {1} was registered for index {2}.", typeName, registeredTypeName, "" + i), PSQLState.DATA_TYPE_MISMATCH);
                }
                ++i;
                ++j;
            }
            rs.close();
            PgCallableStatement pgCallableStatement = this;
            synchronized (pgCallableStatement) {
                this.result = null;
            }
            return false;
        }
        return this.result != null && this.result.getResultSet() != null;
    }

    public void registerOutParameter(int parameterIndex, int sqlType, boolean setPreparedParameters) throws SQLException {
        this.checkClosed();
        switch (sqlType) {
            case -6: {
                sqlType = 5;
                break;
            }
            case -1: {
                sqlType = 12;
                break;
            }
            case 3: {
                sqlType = 2;
                break;
            }
            case 6: {
                sqlType = 8;
                break;
            }
            case -4: 
            case -3: {
                sqlType = -2;
                break;
            }
        }
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("This statement does not declare an OUT parameter.  Use '{' ?= call ... '}' to declare one.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        this.checkIndex(parameterIndex, false);
        Integer oid = this.connection.getTypeInfo().getOid(new Integer(sqlType));
        if (setPreparedParameters || this.isCallable) {
            this.preparedParameters.registerOutParameter(parameterIndex, oid);
        }
        this.functionReturnType[parameterIndex - 1] = sqlType;
        this.testReturn[parameterIndex - 1] = sqlType;
        if (this.functionReturnType[parameterIndex - 1] == 1 || this.functionReturnType[parameterIndex - 1] == -1) {
            this.testReturn[parameterIndex - 1] = 12;
        } else if (this.functionReturnType[parameterIndex - 1] == 6) {
            this.testReturn[parameterIndex - 1] = 7;
        }
        this.returnTypeSet = true;
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale, boolean setPreparedParameters) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, setPreparedParameters);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName, boolean setPreparedParameters) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, setPreparedParameters);
        if (this.preparedParameters instanceof SimpleParameterList) {
            int pIndex = parameterIndex;
            if (this.isFunction) {
                --pIndex;
            }
            if (pIndex > 0) {
                ((SimpleParameterList)this.preparedParameters).setOutParameterTypeName(pIndex, typeName);
            } else {
                ((SimpleParameterList)this.preparedParameters).setReturnTypeName(typeName);
            }
        } else {
            throw Driver.notImplemented(this.getClass(), "registerOutParameter(int, int, String)");
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.lastIndex == 0) {
            throw new PSQLException(GT.tr("wasNull cannot be call before fetching a result.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
        return this.callResult[this.lastIndex - 1] == null;
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 12, "String");
        return (String)this.callResult[parameterIndex - 1];
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -7, "Boolean");
        if (this.callResult[parameterIndex - 1] == null) {
            return false;
        }
        return (Boolean)this.callResult[parameterIndex - 1];
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Byte");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).byteValue();
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 5, "Short");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        return ((Integer)this.callResult[parameterIndex - 1]).shortValue();
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        this.checkClosed();
        int parameterType = this.testReturn[parameterIndex - 1];
        if (!PolarCompDecorater.getInstance().isPolarComp() || parameterType != 2) {
            this.checkIndex(parameterIndex, 4, "Int");
        }
        if (this.callResult[parameterIndex - 1] == null) {
            return 0;
        }
        Object result = this.callResult[parameterIndex - 1];
        if (parameterType == 2) {
            return ((BigDecimal)result).intValue();
        }
        return (Integer)result;
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -5, "Long");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0L;
        }
        return (Long)this.callResult[parameterIndex - 1];
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 7, "Float");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0f;
        }
        return ((Float)this.callResult[parameterIndex - 1]).floatValue();
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 8, "Double");
        if (this.callResult[parameterIndex - 1] == null) {
            return 0.0;
        }
        return (Double)this.callResult[parameterIndex - 1];
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, -3, -2, "Bytes");
        return (byte[])this.callResult[parameterIndex - 1];
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 91, "Date");
        return (Date)this.callResult[parameterIndex - 1];
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 92, "Time");
        return (Time)this.callResult[parameterIndex - 1];
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult[parameterIndex - 1];
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex);
        return this.callResult[parameterIndex - 1];
    }

    @Override
    protected void checkIndex(int parameterIndex, int type1, int type2, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type1 != this.testReturn[parameterIndex - 1] && type2 != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type1), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    @Override
    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn[parameterIndex - 1]) {
            throw new PSQLException(GT.tr("Parameter of type {0} was registered, but call to get{1} (sqltype={2}) was made.", "java.sql.Types=" + this.testReturn[parameterIndex - 1], getName, "java.sql.Types=" + type), PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH);
        }
    }

    private void checkIndex(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, true);
    }

    private void checkIndex(int parameterIndex, boolean fetchingData) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException(GT.tr("A CallableStatement was declared, but no call to registerOutParameter(1, <some type>) was made.", new Object[0]), PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (fetchingData) {
            if (!this.returnTypeSet) {
                throw new PSQLException(GT.tr("No function outputs were registered.", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (this.callResult == null) {
                throw new PSQLException(GT.tr("Results cannot be retrieved from a CallableStatement before it is executed.", new Object[0]), PSQLState.NO_DATA);
            }
            this.lastIndex = parameterIndex;
        }
    }

    @Override
    protected BatchResultHandler createBatchHandler(Query[] queries, ParameterList[] parameterLists) {
        return new CallableBatchResultHandler(this, queries, parameterLists);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.checkClosed();
        this.checkIndex(i, 2003, "Array");
        return (Array)this.callResult[i - 1];
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult[parameterIndex - 1];
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getBlob(int)");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getClob(int)");
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, typeName, !this.adjustIndex);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "registerOutParameter");
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(int)");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getRowId(String)");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream value, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBinaryStream(parameterIndex, value, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBinaryStream(parameterIndex, value);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream value, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setAsciiStream(parameterIndex, value, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setAsciiStream(parameterIndex, value);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBlob(parameterIndex, x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setClob(parameterIndex, x);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNClob(parameterIndex, reader);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(int)");
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNClob(String)");
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(parameterIndex, 2009, "SQLXML");
        return (SQLXML)this.callResult[parameterIndex - 1];
    }

    @Override
    public SQLXML getSQLXML(String parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getSQLXML(String)");
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNString(int)");
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNString(String)");
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getNCharacterStream(String)");
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(int)");
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(String)");
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (type == ResultSet.class) {
            return type.cast(this.getObject(parameterIndex));
        }
        throw new PSQLException(GT.tr("Unsupported type conversion to {1}.", type), PSQLState.INVALID_PARAMETER_VALUE);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getObject(String, Class<T>)");
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.registerOutParameter(parameterIndex, sqlType, typeName);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getURL(String)");
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setURL(parameterIndex, val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(String,Reader,int)");
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        this.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNull(String,int,String)");
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getByte(parameterIndex);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getShort(parameterIndex);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getInt(parameterIndex);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getLong(parameterIndex);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getFloat(parameterIndex);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getDouble(parameterIndex);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getBytes(parameterIndex);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getDate(parameterIndex);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getTimestamp(parameterIndex);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getObject(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getBigDecimal(parameterIndex);
    }

    public Object getObjectImpl(String parameterName, Map map) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getObjectImpl(parameterIndex, map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getRef(parameterIndex);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getBlob(parameterIndex);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getClob(parameterIndex);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getArray(parameterIndex);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getTimestamp(parameterIndex, cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        int parameterIndex = this.getNamedParameterIndex(parameterName);
        return this.getURL(parameterIndex);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        switch (sqlType) {
            case 16: {
                sqlType = -7;
                break;
            }
            case -10: {
                sqlType = 2012;
                break;
            }
        }
        this.registerOutParameter(parameterIndex, sqlType, !this.adjustIndex);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    private int getNamedParameterIndex(String paramName) throws SQLException {
        if (paramName == null) {
            throw new PSQLException(GT.tr("A CallableStatement function was executed with a named parameter as null.", new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
        }
        int thisParameterIndex = this.namedParameters.indexOf(paramName);
        if (thisParameterIndex == -1) {
            throw new PSQLException(GT.tr("A CallableStatement has a named parameter undefined in the calling statement.  Parameter: " + paramName, new Object[0]), PSQLState.INVALID_PARAMETER_TYPE);
        }
        if (this.outParmBeforeFunc) {
            ++thisParameterIndex;
            return ++thisParameterIndex;
        }
        return ++thisParameterIndex;
    }

    private void parseNamedParameters(String sql) throws SQLException {
        int closeParen;
        int openParen;
        this.atLeastOneNamedParameter = false;
        String procedureParameters = "";
        int startIndex = sql.toLowerCase().indexOf("call");
        if (startIndex != -1 && (openParen = sql.indexOf(40, startIndex + 4)) != -1 && (closeParen = sql.indexOf(")", openParen)) != -1) {
            procedureParameters = sql.substring(openParen + 1, closeParen);
        }
        if (procedureParameters != "") {
            procedureParameters = procedureParameters.replaceAll("\\s+", "");
            String[] tmpNamedParams = procedureParameters.split("\\?[\\?,]");
            for (int paramIndex = 0; paramIndex < tmpNamedParams.length; ++paramIndex) {
                int paramFoundIndex = tmpNamedParams[paramIndex].indexOf(NAMED_PARAMETER_INDICATOR);
                if (paramFoundIndex > 0) {
                    this.atLeastOneNamedParameter = true;
                    this.namedParameters.add(tmpNamedParams[paramIndex].substring(0, paramFoundIndex));
                    continue;
                }
                this.namedParameters.add("");
            }
        }
    }
}

