/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.jdbc;

import com.aliyun.polardb.util.GT;
import com.aliyun.polardb.util.PSQLException;
import com.aliyun.polardb.util.PSQLState;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class PolarBlob
implements Blob {
    byte[] bytearray;

    public PolarBlob(byte[] b) {
        this.bytearray = b;
    }

    @Override
    public long length() throws SQLException {
        return this.bytearray.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.assertPosition(pos);
        byte[] b = new byte[length];
        System.arraycopy(this.bytearray, (int)(pos - 1L), b, 0, length);
        return b;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        throw new PSQLException(GT.tr("not implemented.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.assertPosition(start, pattern.length);
        int position = 1;
        int patternIdx = 0;
        long result = -1L;
        int tmpPosition = 1;
        int i = (int)start - 1;
        while (i < this.bytearray.length) {
            byte b = this.bytearray[i];
            if (b == pattern[patternIdx]) {
                if (patternIdx == 0) {
                    tmpPosition = position;
                }
                if (++patternIdx == pattern.length) {
                    result = tmpPosition;
                    break;
                }
            } else {
                patternIdx = 0;
            }
            ++i;
            ++position;
        }
        return result;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new PSQLException(GT.tr("not implemented.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new PSQLException(GT.tr("not implemented.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new PSQLException(GT.tr("not implemented.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public void free() throws SQLException {
        throw new PSQLException(GT.tr("not implemented.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new PSQLException(GT.tr("not implemented.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    protected void assertPosition(long pos) throws SQLException {
        this.assertPosition(pos, 0L);
    }

    protected void assertPosition(long pos, long len) throws SQLException {
        if (pos < 1L) {
            throw new PSQLException(GT.tr("LOB positioning offsets start at 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (pos + len - 1L > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("PostgreSQL LOBs can only index to: {0}", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }
}

