/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.stream;

import com.aliyun.polardb.Driver;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class AbstractEDBSQLOutput
implements SQLOutput {
    private String data = "";
    private int paramIndex = 0;

    public String toString() {
        return this.data;
    }

    private String getSeparator() {
        if (this.paramIndex > 0) {
            return ",";
        }
        return "";
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        this.writeString(x.toString());
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        this.writeBinaryStream(x);
    }

    @Override
    public void writeBigDecimal(BigDecimal x) throws SQLException {
        this.data = this.data + this.getSeparator() + x.toString();
        ++this.paramIndex;
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "writeBinaryStream(InputStream x)");
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        this.writeBinaryStream(x.getBinaryStream());
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x + "'";
        ++this.paramIndex;
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        this.data = this.data + this.getSeparator() + Integer.toString(x);
        ++this.paramIndex;
    }

    @Override
    public void writeBytes(byte[] x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "writeBytes(byte[] x)");
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "writeCharacterStream(Reader x)");
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "writeClob(Clob x)");
    }

    @Override
    public void writeDate(Date x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x.toString() + "'";
        ++this.paramIndex;
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        this.data = this.data + this.getSeparator() + x;
        ++this.paramIndex;
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        this.data = this.data + this.getSeparator() + x;
        ++this.paramIndex;
    }

    @Override
    public void writeInt(int x) throws SQLException {
        this.data = this.data + this.getSeparator() + x;
        ++this.paramIndex;
    }

    @Override
    public void writeLong(long x) throws SQLException {
        this.data = this.data + this.getSeparator() + x;
        ++this.paramIndex;
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        this.data = this.data + "(";
        this.paramIndex = 0;
        x.writeSQL(this);
        this.data = this.data + ")";
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "writeRef(Ref x)");
    }

    @Override
    public void writeShort(short x) throws SQLException {
        this.data = this.data + this.getSeparator() + x;
        ++this.paramIndex;
    }

    @Override
    public void writeString(String x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x + "'";
        ++this.paramIndex;
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "writeStruct(Struct x)");
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x.toString() + "'";
        ++this.paramIndex;
    }

    @Override
    public void writeTimestamp(Timestamp x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x.toString() + "'";
        ++this.paramIndex;
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        this.data = this.data + this.getSeparator() + "'" + x.toString() + "'";
        ++this.paramIndex;
    }
}

