/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.common.utils;

import com.aliyun.tea.NameInMap;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.utils.StringUtils;
import com.google.gson.Gson;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlUtil {
    public static Map<String, Object> DeserializeXml(String xmlStr, Class type) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Document contentXmlDoc;
        Map<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)xmlStr)) {
            return result;
        }
        try {
            contentXmlDoc = DocumentHelper.parseText((String)xmlStr);
        }
        catch (DocumentException e) {
            result = (Map)new Gson().fromJson(xmlStr, Map.class);
            return result;
        }
        Element rootElement = contentXmlDoc.getRootElement();
        Field[] properties = type.getFields();
        Field resultField = null;
        for (Field field : properties) {
            String realName;
            field.setAccessible(true);
            NameInMap nameAnnotation = field.getAnnotation(NameInMap.class);
            String string = realName = nameAnnotation == null ? field.getName() : nameAnnotation.value();
            if (!realName.equals(rootElement.getName())) continue;
            resultField = field;
            break;
        }
        if (null != resultField) {
            if (String.class == resultField.getType()) {
                result.put(rootElement.getName(), rootElement.getText());
                return result;
            }
            result.put(rootElement.getName(), XmlUtil.getValueFromXml(rootElement, resultField.getType()));
        }
        return result;
    }

    private static Map<String, Object> getValueFromXml(Element element, Class type) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Field[] subFields;
        HashMap<String, Object> nodeDict = new HashMap<String, Object>();
        for (Field subField : subFields = type.getFields()) {
            Element selfElement;
            String realName;
            NameInMap nameAnnotation = subField.getAnnotation(NameInMap.class);
            String string = realName = nameAnnotation == null ? subField.getName() : nameAnnotation.value();
            if (subField.getType().isArray()) {
                List subElements = element.elements(realName);
                Object[] target = (Object[])Array.newInstance(subField.getType().getComponentType(), subElements.size());
                for (int i = 0; i < subElements.size(); ++i) {
                    Array.set(target, i, TeaModel.toModel(XmlUtil.getValueFromXml((Element)subElements.get(i), subField.getType().getComponentType()), (TeaModel)((TeaModel)subField.getType().getComponentType().newInstance())));
                }
                nodeDict.put(realName, target);
                continue;
            }
            if (TeaModel.class.isAssignableFrom(subField.getType())) {
                selfElement = element.element(realName);
                if (selfElement == null) continue;
                nodeDict.put(realName, XmlUtil.getValueFromXml(selfElement, subField.getType()));
                continue;
            }
            selfElement = element.element(realName);
            if (selfElement == null) continue;
            nodeDict.put(realName, XmlUtil.castType(subField.getType(), selfElement.getText()));
        }
        return nodeDict;
    }

    private static Object castType(Class clazz, String value) {
        if (Boolean.TYPE == clazz || Boolean.class == clazz) {
            return Boolean.parseBoolean(value);
        }
        if (Integer.TYPE == clazz || Integer.class == clazz) {
            return Integer.parseInt(value);
        }
        if (Long.TYPE == clazz || Long.class == clazz) {
            return Long.parseLong(value);
        }
        return value;
    }

    public static String mapToXml(Map<String, Object> map) throws IllegalAccessException {
        if (null == map || map.isEmpty()) {
            return "";
        }
        if (map.size() != 1) {
            throw new RuntimeException("This map does not have a unique root tag");
        }
        String rootName = map.keySet().toArray(new String[0])[0];
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootName);
        XmlUtil.setValue(root, rootName, map.get(rootName));
        return document.asXML();
    }

    private static void setValue(Element element, String key, Object value) throws IllegalAccessException {
        Class<?> clazz = value.getClass();
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                if (List.class.isAssignableFrom(entry.getValue().getClass())) {
                    XmlUtil.setValue(element, (String)entry.getKey(), entry.getValue());
                    continue;
                }
                Element subElement = element.addElement((String)entry.getKey());
                XmlUtil.setValue(subElement, (String)entry.getKey(), entry.getValue());
            }
        } else if (List.class.isAssignableFrom(clazz)) {
            List list = (List)value;
            for (Object sub : list) {
                if (sub == null) continue;
                Element subElement = element.addElement(key);
                XmlUtil.setValue(subElement, key, sub);
            }
        } else if (TeaModel.class.isAssignableFrom(clazz)) {
            Map map = ((TeaModel)value).toMap();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                if (List.class.isAssignableFrom(entry.getValue().getClass())) {
                    XmlUtil.setValue(element, (String)entry.getKey(), entry.getValue());
                    continue;
                }
                Element subElement = element.addElement((String)entry.getKey());
                XmlUtil.setValue(subElement, (String)entry.getKey(), entry.getValue());
            }
        } else {
            element.setText(String.valueOf(value));
        }
    }
}

