/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeImportSnapshotTasksRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeImportSnapshotTasksRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeImportSnapshotTasksRequest> {
    private ListWithAutoConstructFlag<String> importTaskIds;
    private String nextToken;
    private Integer maxResults;
    private ListWithAutoConstructFlag<Filter> filters;

    public List<String> getImportTaskIds() {
        if (this.importTaskIds == null) {
            this.importTaskIds = new ListWithAutoConstructFlag();
            this.importTaskIds.setAutoConstruct(true);
        }
        return this.importTaskIds;
    }

    public void setImportTaskIds(Collection<String> importTaskIds) {
        if (importTaskIds == null) {
            this.importTaskIds = null;
            return;
        }
        ListWithAutoConstructFlag importTaskIdsCopy = new ListWithAutoConstructFlag(importTaskIds.size());
        importTaskIdsCopy.addAll(importTaskIds);
        this.importTaskIds = importTaskIdsCopy;
    }

    public DescribeImportSnapshotTasksRequest withImportTaskIds(String ... importTaskIds) {
        if (this.getImportTaskIds() == null) {
            this.setImportTaskIds(new ArrayList<String>(importTaskIds.length));
        }
        for (String value : importTaskIds) {
            this.getImportTaskIds().add(value);
        }
        return this;
    }

    public DescribeImportSnapshotTasksRequest withImportTaskIds(Collection<String> importTaskIds) {
        if (importTaskIds == null) {
            this.importTaskIds = null;
        } else {
            ListWithAutoConstructFlag importTaskIdsCopy = new ListWithAutoConstructFlag(importTaskIds.size());
            importTaskIdsCopy.addAll(importTaskIds);
            this.importTaskIds = importTaskIdsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeImportSnapshotTasksRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribeImportSnapshotTasksRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeImportSnapshotTasksRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeImportSnapshotTasksRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    @Override
    public Request<DescribeImportSnapshotTasksRequest> getDryRunRequest() {
        Request<DescribeImportSnapshotTasksRequest> request = new DescribeImportSnapshotTasksRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImportTaskIds() != null) {
            sb.append("ImportTaskIds: " + this.getImportTaskIds() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImportTaskIds() == null ? 0 : this.getImportTaskIds().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportSnapshotTasksRequest)) {
            return false;
        }
        DescribeImportSnapshotTasksRequest other = (DescribeImportSnapshotTasksRequest)obj;
        if (other.getImportTaskIds() == null ^ this.getImportTaskIds() == null) {
            return false;
        }
        if (other.getImportTaskIds() != null && !other.getImportTaskIds().equals(this.getImportTaskIds())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }

    public DescribeImportSnapshotTasksRequest clone() {
        return (DescribeImportSnapshotTasksRequest)super.clone();
    }
}

