/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RequestSpotFleetRequest;
import com.amazonaws.services.ec2.model.SpotFleetLaunchSpecification;
import com.amazonaws.services.ec2.model.SpotFleetMonitoring;
import com.amazonaws.services.ec2.model.SpotFleetRequestConfigData;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.List;

public class RequestSpotFleetRequestMarshaller
implements Marshaller<Request<RequestSpotFleetRequest>, RequestSpotFleetRequest> {
    public Request<RequestSpotFleetRequest> marshall(RequestSpotFleetRequest requestSpotFleetRequest) {
        if (requestSpotFleetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)requestSpotFleetRequest, "AmazonEC2");
        request.addParameter("Action", "RequestSpotFleet");
        request.addParameter("Version", "2015-10-01");
        SpotFleetRequestConfigData spotFleetRequestConfigDataSpotFleetRequestConfig = requestSpotFleetRequest.getSpotFleetRequestConfig();
        if (spotFleetRequestConfigDataSpotFleetRequestConfig != null) {
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getClientToken() != null) {
                request.addParameter("SpotFleetRequestConfig.ClientToken", StringUtils.fromString((String)spotFleetRequestConfigDataSpotFleetRequestConfig.getClientToken()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getSpotPrice() != null) {
                request.addParameter("SpotFleetRequestConfig.SpotPrice", StringUtils.fromString((String)spotFleetRequestConfigDataSpotFleetRequestConfig.getSpotPrice()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getTargetCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.TargetCapacity", StringUtils.fromInteger((Integer)spotFleetRequestConfigDataSpotFleetRequestConfig.getTargetCapacity()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getValidFrom() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidFrom", StringUtils.fromDate((Date)spotFleetRequestConfigDataSpotFleetRequestConfig.getValidFrom()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getValidUntil() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidUntil", StringUtils.fromDate((Date)spotFleetRequestConfigDataSpotFleetRequestConfig.getValidUntil()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.isTerminateInstancesWithExpiration() != null) {
                request.addParameter("SpotFleetRequestConfig.TerminateInstancesWithExpiration", StringUtils.fromBoolean((Boolean)spotFleetRequestConfigDataSpotFleetRequestConfig.isTerminateInstancesWithExpiration()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getIamFleetRole() != null) {
                request.addParameter("SpotFleetRequestConfig.IamFleetRole", StringUtils.fromString((String)spotFleetRequestConfigDataSpotFleetRequestConfig.getIamFleetRole()));
            }
            List<SpotFleetLaunchSpecification> launchSpecificationsList = spotFleetRequestConfigDataSpotFleetRequestConfig.getLaunchSpecifications();
            int launchSpecificationsListIndex = 1;
            for (SpotFleetLaunchSpecification launchSpecificationsListValue : launchSpecificationsList) {
                SpotFleetLaunchSpecification spotFleetLaunchSpecificationMember = launchSpecificationsListValue;
                if (spotFleetLaunchSpecificationMember != null) {
                    SpotPlacement spotPlacementPlacement;
                    if (spotFleetLaunchSpecificationMember.getImageId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".ImageId", StringUtils.fromString((String)spotFleetLaunchSpecificationMember.getImageId()));
                    }
                    if (spotFleetLaunchSpecificationMember.getKeyName() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KeyName", StringUtils.fromString((String)spotFleetLaunchSpecificationMember.getKeyName()));
                    }
                    List<GroupIdentifier> securityGroupsList = spotFleetLaunchSpecificationMember.getSecurityGroups();
                    int securityGroupsListIndex = 1;
                    for (GroupIdentifier securityGroupsListValue : securityGroupsList) {
                        GroupIdentifier groupIdentifierMember = securityGroupsListValue;
                        if (groupIdentifierMember != null) {
                            if (groupIdentifierMember.getGroupName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupName", StringUtils.fromString((String)groupIdentifierMember.getGroupName()));
                            }
                            if (groupIdentifierMember.getGroupId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupId", StringUtils.fromString((String)groupIdentifierMember.getGroupId()));
                            }
                        }
                        ++securityGroupsListIndex;
                    }
                    if (spotFleetLaunchSpecificationMember.getUserData() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".UserData", StringUtils.fromString((String)spotFleetLaunchSpecificationMember.getUserData()));
                    }
                    if (spotFleetLaunchSpecificationMember.getAddressingType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".AddressingType", StringUtils.fromString((String)spotFleetLaunchSpecificationMember.getAddressingType()));
                    }
                    if (spotFleetLaunchSpecificationMember.getInstanceType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceType", StringUtils.fromString((String)spotFleetLaunchSpecificationMember.getInstanceType()));
                    }
                    if ((spotPlacementPlacement = spotFleetLaunchSpecificationMember.getPlacement()) != null) {
                        if (spotPlacementPlacement.getAvailabilityZone() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.AvailabilityZone", StringUtils.fromString((String)spotPlacementPlacement.getAvailabilityZone()));
                        }
                        if (spotPlacementPlacement.getGroupName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.GroupName", StringUtils.fromString((String)spotPlacementPlacement.getGroupName()));
                        }
                    }
                    if (spotFleetLaunchSpecificationMember.getKernelId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KernelId", StringUtils.fromString((String)spotFleetLaunchSpecificationMember.getKernelId()));
                    }
                    if (spotFleetLaunchSpecificationMember.getRamdiskId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".RamdiskId", StringUtils.fromString((String)spotFleetLaunchSpecificationMember.getRamdiskId()));
                    }
                    List<BlockDeviceMapping> blockDeviceMappingsList = spotFleetLaunchSpecificationMember.getBlockDeviceMappings();
                    int blockDeviceMappingsListIndex = 1;
                    for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                        BlockDeviceMapping blockDeviceMappingMember = blockDeviceMappingsListValue;
                        if (blockDeviceMappingMember != null) {
                            EbsBlockDevice ebsBlockDeviceEbs;
                            if (blockDeviceMappingMember.getVirtualName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)blockDeviceMappingMember.getVirtualName()));
                            }
                            if (blockDeviceMappingMember.getDeviceName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)blockDeviceMappingMember.getDeviceName()));
                            }
                            if ((ebsBlockDeviceEbs = blockDeviceMappingMember.getEbs()) != null) {
                                if (ebsBlockDeviceEbs.getSnapshotId() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebsBlockDeviceEbs.getSnapshotId()));
                                }
                                if (ebsBlockDeviceEbs.getVolumeSize() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebsBlockDeviceEbs.getVolumeSize()));
                                }
                                if (ebsBlockDeviceEbs.isDeleteOnTermination() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebsBlockDeviceEbs.isDeleteOnTermination()));
                                }
                                if (ebsBlockDeviceEbs.getVolumeType() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebsBlockDeviceEbs.getVolumeType()));
                                }
                                if (ebsBlockDeviceEbs.getIops() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebsBlockDeviceEbs.getIops()));
                                }
                                if (ebsBlockDeviceEbs.isEncrypted() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebsBlockDeviceEbs.isEncrypted()));
                                }
                            }
                            if (blockDeviceMappingMember.getNoDevice() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)blockDeviceMappingMember.getNoDevice()));
                            }
                        }
                        ++blockDeviceMappingsListIndex;
                    }
                    SpotFleetMonitoring spotFleetMonitoringMonitoring = spotFleetLaunchSpecificationMember.getMonitoring();
                    if (spotFleetMonitoringMonitoring != null && spotFleetMonitoringMonitoring.isEnabled() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Monitoring.Enabled", StringUtils.fromBoolean((Boolean)spotFleetMonitoringMonitoring.isEnabled()));
                    }
                    if (spotFleetLaunchSpecificationMember.getSubnetId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SubnetId", StringUtils.fromString((String)spotFleetLaunchSpecificationMember.getSubnetId()));
                    }
                    List<InstanceNetworkInterfaceSpecification> networkInterfacesList = spotFleetLaunchSpecificationMember.getNetworkInterfaces();
                    int networkInterfacesListIndex = 1;
                    for (InstanceNetworkInterfaceSpecification networkInterfacesListValue : networkInterfacesList) {
                        InstanceNetworkInterfaceSpecification instanceNetworkInterfaceSpecificationMember = networkInterfacesListValue;
                        if (instanceNetworkInterfaceSpecificationMember != null) {
                            if (instanceNetworkInterfaceSpecificationMember.getNetworkInterfaceId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getNetworkInterfaceId()));
                            }
                            if (instanceNetworkInterfaceSpecificationMember.getDeviceIndex() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)instanceNetworkInterfaceSpecificationMember.getDeviceIndex()));
                            }
                            if (instanceNetworkInterfaceSpecificationMember.getSubnetId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getSubnetId()));
                            }
                            if (instanceNetworkInterfaceSpecificationMember.getDescription() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getDescription()));
                            }
                            if (instanceNetworkInterfaceSpecificationMember.getPrivateIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationMember.getPrivateIpAddress()));
                            }
                            List<String> groupsList = instanceNetworkInterfaceSpecificationMember.getGroups();
                            int groupsListIndex = 1;
                            for (String groupsListValue : groupsList) {
                                if (groupsListValue != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)groupsListValue));
                                }
                                ++groupsListIndex;
                            }
                            if (instanceNetworkInterfaceSpecificationMember.isDeleteOnTermination() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationMember.isDeleteOnTermination()));
                            }
                            List<PrivateIpAddressSpecification> privateIpAddressesList = instanceNetworkInterfaceSpecificationMember.getPrivateIpAddresses();
                            int privateIpAddressesListIndex = 1;
                            for (PrivateIpAddressSpecification privateIpAddressesListValue : privateIpAddressesList) {
                                PrivateIpAddressSpecification privateIpAddressSpecificationMember = privateIpAddressesListValue;
                                if (privateIpAddressSpecificationMember != null) {
                                    if (privateIpAddressSpecificationMember.getPrivateIpAddress() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)privateIpAddressSpecificationMember.getPrivateIpAddress()));
                                    }
                                    if (privateIpAddressSpecificationMember.isPrimary() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)privateIpAddressSpecificationMember.isPrimary()));
                                    }
                                }
                                ++privateIpAddressesListIndex;
                            }
                            if (instanceNetworkInterfaceSpecificationMember.getSecondaryPrivateIpAddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)instanceNetworkInterfaceSpecificationMember.getSecondaryPrivateIpAddressCount()));
                            }
                            if (instanceNetworkInterfaceSpecificationMember.isAssociatePublicIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationMember.isAssociatePublicIpAddress()));
                            }
                        }
                        ++networkInterfacesListIndex;
                    }
                    IamInstanceProfileSpecification iamInstanceProfileSpecificationIamInstanceProfile = spotFleetLaunchSpecificationMember.getIamInstanceProfile();
                    if (iamInstanceProfileSpecificationIamInstanceProfile != null) {
                        if (iamInstanceProfileSpecificationIamInstanceProfile.getArn() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfileSpecificationIamInstanceProfile.getArn()));
                        }
                        if (iamInstanceProfileSpecificationIamInstanceProfile.getName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfileSpecificationIamInstanceProfile.getName()));
                        }
                    }
                    if (spotFleetLaunchSpecificationMember.isEbsOptimized() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".EbsOptimized", StringUtils.fromBoolean((Boolean)spotFleetLaunchSpecificationMember.isEbsOptimized()));
                    }
                    if (spotFleetLaunchSpecificationMember.getWeightedCapacity() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".WeightedCapacity", StringUtils.fromDouble((Double)spotFleetLaunchSpecificationMember.getWeightedCapacity()));
                    }
                    if (spotFleetLaunchSpecificationMember.getSpotPrice() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SpotPrice", StringUtils.fromString((String)spotFleetLaunchSpecificationMember.getSpotPrice()));
                    }
                }
                ++launchSpecificationsListIndex;
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getExcessCapacityTerminationPolicy() != null) {
                request.addParameter("SpotFleetRequestConfig.ExcessCapacityTerminationPolicy", StringUtils.fromString((String)spotFleetRequestConfigDataSpotFleetRequestConfig.getExcessCapacityTerminationPolicy()));
            }
            if (spotFleetRequestConfigDataSpotFleetRequestConfig.getAllocationStrategy() != null) {
                request.addParameter("SpotFleetRequestConfig.AllocationStrategy", StringUtils.fromString((String)spotFleetRequestConfigDataSpotFleetRequestConfig.getAllocationStrategy()));
            }
        }
        return request;
    }
}

